#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

#!/bin/bash
failed_scripts=()
run_script() {
    local script_name=$1
    shift
    ./$script_name $@
    if [ $? -ne 0 ]; then
        failed_scripts+=($script_name)
    fi
}
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------1 check_search --------------------------------"
run_script check_search.sh 
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------2 check_search_arch--------------------------------"
run_script check_search_arch.sh arm64 
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------3 check_install--------------------------------"
run_script check_install.sh 
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------4 check_install_arch--------------------------------"
run_script check_install_arch.sh arm64 top.openkylin.video
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------5 check_install_kind--------------------------------"
run_script check_install_kind.sh depend top.openkylin.python-3.11
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------6 check_install_id--------------------------------"
run_script check_install_id.sh top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------7 check_install_id_version--------------------------------"
run_script check_install_id_version.sh top.openkylin.Music 2.0.0.0
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------8 check_install_id_version_module  --------------------------------"
run_script check_install_id_version_module.sh top.openkylin.Music 2.0.0.0 binary
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------9 check_install_id_version_module_channel_arch--------------------------------"
run_script check_install_id_version_module_channel_arch.sh top.openkylin.Music 2.0.0.0 binary stable x86_64
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------10 check_list--------------------------------"
run_script check_list.sh
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------11 check_list_kind--------------------------------"
run_script check_list_kind.sh depend
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------12 check_list_arch--------------------------------"
run_script check_list_arch.sh arm64
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------13 check_info--------------------------------"
run_script check_info.sh top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------14 check_info_arch--------------------------------"
run_script check_info_arch.sh arm64 top.openkylin.video
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------15 check_update--------------------------------"
run_script check_update.sh top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------16 check_update_arch--------------------------------"
run_script check_update_arch.sh x86_64 top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------17 check_repair--------------------------------"
run_script check_repair.sh top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------18 check_repair_arch--------------------------------"
run_script check_repair_arch.sh arm64 top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------19 check_uninstall--------------------------------"
run_script check_uninstall.sh top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
echo "-------------------------------start--------------------------------"
echo "-------------------------------20 check_uninstall_arch--------------------------------"
run_script check_uninstall_arch.sh x86_64 top.openkylin.Music
echo "-------------------------------end--------------------------------"
echo
if [ ${#failed_scripts[@]} -ne 0 ]; then
    echo "以下脚本执行失败: ${failed_scripts[@]}"
    exit 1
fi