#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

#!/bin/bash
if [ $# -ne 2 ]; then
    echo "请提供应用架构和名称作为参数"
    exit 1
fi
# 要检查的父目录
parent_dir="/opt/kaiming/layers"

# 要查找的目标目录名称
app_arch="$1"
app_name="$2"

# 使用find命令查找第4层目录中是否存在目标目录
if find "$parent_dir" -mindepth 4 -maxdepth 4 -type d -name "$app_name" | grep -q .; then
    sudo kaiming uninstall -y --arch=$app_arch $app_name
else
    echo "未安装${app_arch}架构的${app_name}"
    exit 1
fi
if find "$parent_dir" -mindepth 4 -maxdepth 4 -type d -name "$app_name" | grep -q .; then
    echo "卸载${app_arch}架构的${app_name}失败"
else
    echo "成功卸载${app_arch}架构的${app_name}"
    exit 1
fi

