#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

#!/bin/bash
if [ $# -eq 0 ]; then
    echo "请提供应用名称作为参数"
    exit 1
fi
# 要检查的父目录
parent_dir="/opt/kaiming/layers"

# 要查找的目标目录名称
target_dir="$1"

# 使用find命令查找第4层目录中是否存在目标目录
if find "$parent_dir" -mindepth 4 -maxdepth 4 -type d -name "$target_dir" | grep -q .; then
    sudo kaiming uninstall -y ${target_dir}
else
    echo "未安装${target_dir}"
fi
if find "$parent_dir" -mindepth 4 -maxdepth 4 -type d -name "$target_dir" | grep -q .; then
    echo "卸载失败"
    exit 1
else
    echo "成功卸载${target_dir}"
fi

