#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

#!/bin/bash
if [ $# -eq 0 ]; then
    echo "请提供应用类型作为参数"
    exit 1
fi
sudo kaiming install --kind=$1 $2 
if [ $? -ne 0 ]; then
    echo "安装$1类型$2失败"
    exit 1
fi
found_dir=$(find /opt/kaiming/layers/ -type d -name "$1" 2>/dev/null)
if [ -n "$found_dir" ]; then
    found_id=$(find $found_dir -type d -name "$2" 2>/dev/null)
    if [ -n "$found_id" ]; then
        echo "安装$1类型$2成功"
    else
        echo "安装$1类型$2失败"
        exit 1
    fi
else
    echo "安装$1类型的$2失败"
    exit 1
fi
