#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

#!/bin/bash
if [ $# -ne 2 ]; then
    echo "请提供应用架构和名称作为参数"
    exit 1
fi
sudo kaiming install --arch=$1 $2 
if [ $? -ne 0 ]; then
    echo "安装$1架构$2失败"
    exit 1
fi
found_dir=$(find /opt/kaiming/layers/ -type d -name "$1" 2>/dev/null)
if [ -n "$found_dir" ]; then
    found_id=$(find $found_dir -type d -name "$2" 2>/dev/null)
    if [ -n "$found_id" ]; then
        echo "安装$1架构$2成功"
    else
        echo "安装$1架构$2失败"
        exit 1
    fi
else
    echo "安装$1架构$2失败"
    exit 1
fi