#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

#!/bin/bash

# 检查是否提供了参数
if [ $# -ne 2 ]; then
    echo "请提供应用架构和名称作为参数"
    exit 1
fi
# 获取应用名称
app_arch="$1"
app_name="$2"
# 要检查的父目录
parent_dir="/opt/kaiming/layers"
# 使用 kaiming info 获取信息并提取 Id
id_value=$(kaiming info --arch=$app_arch $app_name | sed 's/\x1B\[[0-9;]*[mGK]//g' | grep "^Id:" | head -n 1 | cut -d' ' -f2)

if [ "$app_name" = "$id_value" ]; then
    # 使用find命令查找第4层目录中是否存在目标目录
    arch_dir=$(find "$parent_dir" -mindepth 2 -maxdepth 2 -type d -name "$app_arch")
    if [ -n "$arch_dir" ] && find "$arch_dir" -mindepth 2 -maxdepth 2 -type d -name "$app_name" | grep -q .; then
        echo "已安装${app_arch}架构的${app_name}"
    else
        echo "未安装${app_arch}架构的${app_name}"
        exit 1
    fi
else
    echo "未安装${app_arch}架构的${app_name}"
    exit 1
fi
