/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 *
 * See the LICENSE file for more details.
 */

#include "KMRunner.h"
#include "KMKill.h"

#include <gtest/gtest.h>
#include <thread>  // For std::this_thread::sleep_for
#include <chrono>  // For std::chrono::seconds
#define private public

class KMTestRunner
{
public:
    KMTestRunner() = default;
    ~KMTestRunner() = default;

public:
    KMRunner m_runner;
    KMKill m_killer;
};

TEST(KMTestRunner, test_run)
{
    KMTestRunner testRunner;

    const char *argv[] = {"run", "top.openkylin.Recorder"};
    const char *argv1[] = {"kill", "top.openkylin.Recorder"};
    std::thread runThread([&]() 
        {
            EXPECT_EQ(testRunner.m_runner.dispose(2,const_cast<char**>(argv)), -1);
        }
    ); 
    std::this_thread::sleep_for(std::chrono::seconds(2));

    testRunner.m_killer.dispose(2, const_cast<char**>(argv));
    runThread.join();
}