/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 *
 * See the LICENSE file for more details.
 */

#include "KMPS.h"
#include "KMRunner.h"
#include "KMKill.h"
#include <gtest/gtest.h>

#include <thread> 
#include <chrono>  

#define private public

class KMTestPS
{
public:
    KMTestPS() = default;
    ~KMTestPS() = default;

public:
    KMPS m_ps;
    KMRunner m_runner;
    KMKill m_kill;

};



TEST(KMTestPS, test_ps)
{
    KMTestPS testps;
    const char *argv[] = {"run", "top.openkylin.Recorder"};
    const char *argv1[] = {"ps", "top.openkylin.Recorder"};
    const char *argv2[] = {"kill", "top.openkylin.Recorder"};

    std::thread runThread([&]() 
        {
            testps.m_runner.dispose(2, const_cast<char**>(argv));
        }
    ); 
    
    std::this_thread::sleep_for(std::chrono::seconds(2));
    EXPECT_EQ(testps.m_ps.dispose(2,const_cast<char**>(argv1)), EXIT_SUCCESS);
    EXPECT_EQ(testps.m_kill.dispose(2,const_cast<char**>(argv2)), EXIT_SUCCESS);

    runThread.join();
}
