/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 *
 * See the LICENSE file for more details.
 */

#include "KMKill.h"
#include "KMRunner.h"

#include <gtest/gtest.h>

#include <thread>  // For std::this_thread::sleep_for
#include <chrono>  // For std::chrono::seconds

#define private public

class KMTestKill
{
public:
    KMTestKill() = default;
    ~KMTestKill() = default;

public:
    KMKill m_killer;
    KMRunner m_runner;
};



TEST(KMTestKill, test_kill)
{
    KMTestKill testKiller;
    const char *argv[] = {"run", "top.openkylin.Recorder"};
    const char *argv1[] = {"kill", "top.openkylin.Recorder"};

    std::thread runThread([&]() 
        {
            testKiller.m_runner.dispose(2, const_cast<char**>(argv));
        }
    ); 
    std::this_thread::sleep_for(std::chrono::seconds(2));

    EXPECT_EQ(testKiller.m_killer.dispose(2, const_cast<char**>(argv1)), false);
    runThread.join();
}