/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 *
 * See the LICENSE file for more details.
 */

// #define private public
#include "KMEnter.h"
#include "KMRunner.h"
#include "KMKill.h"
#include <gtest/gtest.h>

#include <thread> 
#include <chrono>  

#define private public

class KMTestEnter
{
public:
    KMTestEnter() = default;
    ~KMTestEnter() = default;

public:
    KMEnter m_enter;
    KMRunner m_runner;
    KMKill m_kill;
};



TEST(KMTestEnter, test_enter)
{
    KMTestEnter testenter;

    const char *argv[] = {"run", "top.openkylin.Recorder"};
    const char *argv1[] = {"enter", "top.openkylin.Recorder","ls"};
    const char *argv2[] = {"kill", "top.openkylin.Recorder"};

    std::thread runThread([&]() 
        {
            testenter.m_runner.dispose(2, const_cast<char**>(argv));
        }
    ); 

    std::this_thread::sleep_for(std::chrono::seconds(2));
    EXPECT_GE(testenter.m_enter.dispose(3,const_cast<char**>(argv1)), 0);   
    EXPECT_GE(testenter.m_kill.dispose(2,const_cast<char**>(argv2)), 0);
    runThread.join();
}
