#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#


#!/bin/bash

_kaiming() {
  local pre cur opts
  COMPREPLY=()
  pre="${COMP_WORDS[COMP_CWORD-1]}"
  cur="${COMP_WORDS[COMP_CWORD]}"
	case $COMP_CWORD in 
	1)
    opts="install repair uninstall update upgrade list info enter export run ps kill search which build build-init build-finish build-export remote-modify --help --version -h -v "
    ;;	
	2)
		if [[ ${COMP_WORDS[1]} == "run" ]];then
       opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                  -path '*/app/*' -o \
                  -path '*/base/*' -o \
                  -path '*/runtime/*' -o \
                  -path '*/extension/*' -o \
                  -path '*/depend/*' 2>/dev/null | \
                  xargs -I {} basename {} | sort | uniq) \
                  --help --verbose --devel --file-forwarding --command= -h -v -d"  
		fi
    ;;
  3)
    if [[ "${COMP_WORDS[1]}" == "run" && "${COMP_WORDS[2]}" ]];  then
        opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                -path '*/app/*' -o \
                -path '*/base/*' -o \
                -path '*/runtime/*' -o \
                -path '*/extension/*' -o \
                -path '*/depend/*' 2>/dev/null | \
                xargs -I {} basename {} | sort | uniq)"
    fi
    ;;
  4)
    if [[ "${COMP_WORDS[1]}" == "run" && "${COMP_WORDS[3]}" ]]; then
        opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                -path '*/app/*' -o \
                -path '*/base/*' -o \
                -path '*/runtime/*' -o \
                -path '*/extension/*' -o \
                -path '*/depend/*' 2>/dev/null | \
                xargs -I {} basename {} | sort | uniq)"
    fi
    ;;
  5)
    if [[ "${COMP_WORDS[1]}" == "run" && "${COMP_WORDS[4]}" ]]; then
        opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                -path '*/app/*' -o \
                -path '*/base/*' -o \
                -path '*/runtime/*' -o \
                -path '*/extension/*' -o \
                -path '*/depend/*' 2>/dev/null | \
                xargs -I {} basename {} | sort | uniq)"
    fi
  esac

  if [[ ${COMP_WORDS[1]} == "info" ]]; then
    if [[ ${COMP_CWORD} -ge 3 && ${COMP_WORDS[2]} == "-L" || ${COMP_WORDS[2]} == "--listfiles" ]]; then
      opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                -path '*/app/*' -o \
                -path '*/base/*' -o \
                -path '*/runtime/*' -o \
                -path '*/extension/*' -o \
                -path '*/depend/*' 2>/dev/null | \
                xargs -I {} basename {} | sort | uniq )"
    else
      opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                -path '*/app/*' -o \
                -path '*/base/*' -o \
                -path '*/runtime/*' -o \
                -path '*/extension/*' -o \
                -path '*/depend/*' 2>/dev/null | \
                xargs -I {} basename {} | sort | uniq ) \
                --help --verbose -h -v -L --listfiles --arch"
    fi
  fi
  if [[ ${COMP_WORDS[1]} == "uninstall" ]];then
        opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
                  -path '*/app/*' -o \
                  -path '*/base/*' -o \
                  -path '*/runtime/*' -o \
                  -path '*/extension/*' -o \
                  -path '*/depend/*' 2>/dev/null | \
                  xargs -I {} basename {} | sort | uniq ) \
                  --help --verbose --assumeyes --arch --unused --delete-data -h -y -v"
  fi
  if [[ ${COMP_WORDS[1]} == "list" ]];then
      opts="--help --verbose --arch --kind --module -h -v"
  fi
  if [[ ${COMP_WORDS[1]} == "enter" ]];then
        opts="$(kaiming ps | awk 'NR>1 {print $1}') --help -h"
  fi
  if [[ ${COMP_WORDS[1]} == "ps" ]];then
        opts="--help -h"
  fi
  if [[ ${COMP_WORDS[1]} == "kill" ]];then
        opts="$(kaiming ps | awk 'NR>1 {print $1}') --help -h"
  fi
  if [[ ${COMP_WORDS[1]} == "export" ]];then
        opts="$(find /opt/kaiming/layers -mindepth 4 -maxdepth 4 -type d \
            -path '*/app/*' -o \
            -path '*/base/*' -o \
            -path '*/runtime/*' -o \
            -path '*/extension/*' -o \
            -path '*/depend/*' 2>/dev/null | \
            xargs -I {} basename {} | sort | uniq ) \
            --help -y -v"
  fi
  if [[ ${COMP_WORDS[1]} == "build-init" ]];then
      opts="--help --arch= --runtime= --base --kind= --channel= -h"
  fi
  if [[ ${COMP_WORDS[1]} == "build" ]];then
        opts="--help --build-mount= --build-dir= --with-appdir --die-with-parent= --env= --unset-env= -h -p"
  fi
  if [[ ${COMP_WORDS[1]} == "build-finish" ]];then
        opts="--help --extra-data --env= --unset-env= -h"
  fi
  if [[ ${COMP_WORDS[1]} == "build-export" ]];then
        opts="--help --arch= --exclude --include -h"
  fi
  if [[ ${COMP_WORDS[1]} == "install" ]];then
      if [[ -f /opt/kaiming/packages ]]; then
        opts="$(cat /opt/kaiming/packages | sort | uniq | tr '\n' ' ') --help --verbose --assumeyes --arch -h -y -v --kind --force -i --skip-signature-verification"
      else
        opts="--help --verbose --assumeyes --arch -h -y -v --kind --force -i --skip-signature-verification"
      fi
  fi
  if [[ ${COMP_WORDS[1]} == "repair" ]];then
      if [[ -f /opt/kaiming/packages ]]; then
        opts="$(cat /opt/kaiming/packages | sort | uniq | tr '\n' ' ') --help --verbose --assumeyes --arch -h -y -v"
      else
        opts="--help --verbose --assumeyes --arch -h -y -v"
      fi
  fi
  if [[ ${COMP_WORDS[1]} == "update" ]];then
      if [[ -f /opt/kaiming/packages ]]; then
        opts="$(cat /opt/kaiming/packages | sort | uniq | tr '\n' ' ') --help --verbose --assumeyes --arch -h -y -v --upgradable"
      else
        opts="--help --verbose --assumeyes --arch= -h -y -v --upgradable"
      fi
  fi
  if [[ ${COMP_WORDS[1]} == "upgrade" ]];then
      if [[ -f /opt/kaiming/packages ]]; then
        opts="$(cat /opt/kaiming/packages | sort | uniq | tr '\n' ' ') --help --assumeyes -h -y"
      else
        opts="--help --assumeyes -h -y"
      fi
  fi
  if [[ ${COMP_WORDS[1]} == "search" ]];then
      if [[ -f /opt/kaiming/packages ]]; then
        opts="$(cat /opt/kaiming/packages | sort | uniq | tr '\n' ' ') --help --verbose --assumeyes --arch --module --kind -h -v"
      else
        opts="--help --verbose --arch --module --kind -h -v"
      fi
  fi
  if [[ ${COMP_WORDS[1]} == "which" ]];then
        opts="--help -h -v"
  fi
  if [[ ${COMP_WORDS[1]} == "remote-modify" ]];then
        opts="--help -h --repo"
  fi
  if [[ ${COMP_WORDS[1]} == "install" || ${COMP_WORDS[1]} == "which" ]]; then
    COMPREPLY=( $(compgen -f -W "${opts}" -- ${cur}) )
    compopt -o nospace
  else
    COMPREPLY=( $(compgen -W "${opts}" -- ${cur}) )
  fi

}

complete -F _kaiming kaiming
