#!/bin/bash

# 获取当前用户的UID
current_uid=$(id -u)

# 获取脚本文件名（去掉路径）
script_name=$(basename "$0")

if [ "$current_uid" -eq 0 ] ; then
   # 通过D-Bus发送请求
  dbus-send --system \
    --reply-timeout=100000000000 \
    --print-reply \
    --dest=org.kaiming.proxy \
    /org/kaiming/proxy \
    org.kaiming.proxy.system.startBinaryAsUser \
    int32: $urrent_uid \
    string:"$script_name" 
else 
  dbus-send --session \
    --reply-timeout=100000000000 \
    --print-reply \
    --dest=org.kaiming.proxy \
    /org/kaiming/proxy \
    org.kaiming.proxy.session.startBinaryAsUser \
    int32:"$current_uid" \
    string:"$script_name"
fi