/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __KMOABRUN_H__
#define __KMOABRUN_H__

#include <string>
#include <map>
#include <vector>
#include <memory>

#include "common/KMSubCommand.h"

class KMOABRun : public KMSubCommand
{
    DECLARE_DYNCREATE(KMOABRun);

public:
    explicit KMOABRun();
    virtual ~KMOABRun();

    int dispose(int argc, char **argv) override;

private:
    void init(int argc, char **argv);
    int run();

    void parseElf();
    void ensureLayers();
    void ensureAppDataDir();
    std::string genMountPoint();

    void addEnv(const std::string &key, const std::string &value);
    void removeEnv(const std::string &key);
    void addShareMount(const std::string &name, const std::string &content, const std::string &dest, const std::vector<std::string> &options);
    void lowerToUpperForSubDir(const std::string &lowerdir, const std::string &upperdir);
    void mountBase();

    void initMinimalEnvs(bool devel, bool useLdSoCache);
    void setupOverlayfs();
    void setupBase();
    void setupTZData();
    void setupMonitorPath();
    void setupRuntime();
    void setupAppInfo();
    void setupAppDataDir(const std::string &id);
    void setupAppContext();
    void setProcess();
    void setupProcessEnvs();

    void setupDev();
    void setupFileSystem();
    void setupWayland();
    void setupX11();
    void setupSsh();
    void setupPulseaudio();
    void setupPcsc();
    void setupCups();
    void setupGpgAgent();
    void setupSessionDbus();
    void setupSystemDbus();
    void setupA11yDbus();
    void setupGssproxy();
    void setupResolved();
    void setupJournal();

    void exec();

private:
    static const std::map<std::string, std::string> m_defalutEnvs;
    static const std::map<std::string, std::string> m_develEnvs;
    static const std::vector<std::string> m_copyEnvs;
    static const std::vector<std::string> m_copyNoDevelEnvs;
    static const std::vector<std::string> m_overlayfs;

private:
    class Options;
    class Private;
    std::unique_ptr<Private> d;
};

#endif // !__KMOABRUN_H__
