#!/bin/sh

#
# Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
#
# kaiming is licensed under the GPL v2.0+.
#
# See the LICENSE file for more details.
#

if command -v kaiming > /dev/null; then
    kaiming_new_dirs=$(
        (
            unset G_MESSAGES_DEBUG
            echo "${XDG_DATA_HOME:-"$HOME/.local/share"}/kaiming"
            GIO_USE_VFS=local
        ) | (
            kaiming_new_dirs=
            while read -r kaiming_data_path
            do
                kaiming_share_path=/opt/kaiming/share
                case ":$XDG_DATA_DIRS:" in
                    (*":$kaiming_share_path/:"*) :;;
                    (*":$kaiming_share_path:"*) :;;
                    (*) kaiming_new_dirs=${kaiming_new_dirs:+${kaiming_new_dirs}:}$kaiming_share_path;;
                esac

                # kaiming_exports_share_path=/opt/kaiming/exports/share
                # case ":$XDG_DATA_DIRS:" in
                #     (*":$kaiming_exports_share_path/:"*) :;;
                #     (*":$kaiming_exports_share_path:"*) :;;
                #     (*) kaiming_new_dirs=${kaiming_new_dirs:+${kaiming_new_dirs}:}$kaiming_exports_share_path;;
                # esac
            done
            echo "$kaiming_new_dirs"
        )
    )

    export XDG_DATA_DIRS
    XDG_DATA_DIRS="${kaiming_new_dirs:+${kaiming_new_dirs}:}${XDG_DATA_DIRS:-/usr/local/share:/usr/share}"
    export PATH=$PATH:/opt/kaiming/bin
    #echo "$XDG_DATA_DIRS"
fi
