/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __KMOKPACKAGE_H__
#define __KMOKPACKAGE_H__

#include <string>
#include <memory>

#include "KMInfoJson.h"
#include "KMOABMetadata.h"

class KMOKPackager
{
public:
    struct Layer
    {
        std::string m_layerDir;
        std::shared_ptr<KMInfoJson> m_info;
    };

public:
    KMOKPackager(const std::string &buildDir, bool exportAll = false);
    ~KMOKPackager();

    void setIcon(const std::string &icon);

    void setBundleFilesystem(const std::string &filesystem);

    void setModulePaths(const std::string &moduleName, const std::string& paths);
    
    void appendLayer(Layer layer);

    void pack(const std::string &okFilename);

private:
    void addNewSection(const std::string &sectionName, const std::string &dataFile);

    void packIcon();

    void packBundle();

    void prepareBundle(const std::string &bundleDir);

    void generateErofsBundle(const std::string &bundleFile, const std::string &bundleDir);
    void generateSquashfsBundle(const std::string &bundleFile, const std::string &bundleDir);

    void packMetadata();

private:
    class Private;
    std::shared_ptr<Private> d;
};

#endif // !__KMOKPACKAGE_H__
