/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __FILEGUARD_H__
#define __FILEGUARD_H__

/**
 * @brief 	 文件描述符保护类
 * @note     用于已打开文件描述符在KMFileGuard对象析构时的自动关闭
 */
class KMFileGuard
{
public:
    KMFileGuard(int fd = -1);
    ~KMFileGuard();

    void setFd(int fd);
    int fd() const
    {
        return m_fd;
    }
    int stealFd()
    {
        int fd = m_fd;
        m_fd = -1;
        return fd;
    }

private:
    int m_fd;
};

#endif // !__FILEGUARD_H__
