/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#include "KMFileGuard.h"

#include <unistd.h>

KMFileGuard::KMFileGuard(int fd)
    : m_fd(fd)
{
}

KMFileGuard::~KMFileGuard()
{
    if (m_fd > 2)
    {
        close(m_fd);
    }
}

void KMFileGuard::setFd(int fd)
{
    if (m_fd > 2)
    {
        close(m_fd);
    }

    m_fd = fd;
}
