/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef KMERROR_H
#define KMERROR_H

#include <iostream>
#include <map>
#include <string>

/**
 * Error codes for library and dbus functions.
 */
typedef enum
{
    KM_ERROR_NO = 0,                         // success
    KM_ERROR_CHECK_ENV_FAILED,               // Check env failed.
    KM_ERROR_GET_SUMMARY_COMMIT_FAILED,      // Get commit from summary.idx failed
    KM_ERROR_INVALID_ARGS,                   // Input args are invalid.
    KM_ERROR_NEED_NEW_VERSION,               // The App/Runtime needs a more recent version of KM.
    KM_ERROR_ALREADY_INSTALLED,              // App/runtime/remote is already installed
    KM_ERROR_NOT_INSTALLED,                  // App/runtime is not installed
    KM_ERROR_NOT_UNINSTALLED,                // App/runtime is not installed
    KM_ERROR_INSTALL_ONLY_PULLED,            // App/runtime was only pulled into the local repository but not installed.
    KM_ERROR_DIFFERENT_REMOTE,               // The App/Runtime is already installed, but from a different remote.
    KM_ERROR_INSTALL_SKIPPED,                // The App/Runtime install was skipped due to earlier errors.
    KM_ERROR_REMOTE_NOT_FOUND,               // The specified remote was not found.
    KM_ERROR_RUNTIME_NOT_FOUND,              // A runtime needed for the app was not found.
    KM_ERROR_REF_NOT_FOUND,                  // The specified ref was not found.
    KM_ERROR_REF_NOT_INSTALLED,              // The specified ref is not installed.
    KM_ERROR_REF_COMMIT_NOT_FOUND,           // Subsummary ref commit not found.
    KM_ERROR_DOWNGRADE,                      // The pulled commit is a downgrade, and a downgrade wasn't specifically allowed.
    KM_ERROR_PULL_FAILED,                    // The pulled is failed.
    KM_ERROR_INVALID_REF,                    // A ref could not be parsed.
    KM_ERROR_INVALID_DATA,                   // Invalid data.
    KM_ERROR_SETUP_FAILED,                   // Sandbox setup failed.
    KM_ERROR_EXPORT_FAILED,                  // Exporting data failed.
    KM_ERROR_REMOTE_USED,                    // Remote can't be uninstalled.
    KM_ERROR_RUNTIME_USED,                   // Runtime can't be uninstalled.
    KM_ERROR_INVALID_NAME,                   // Application, runtime or remote name is invalid.
    KM_ERROR_OUT_OF_SPACE,                   // More disk space needed.
    KM_ERROR_WRONG_USER,                     // An operation is being attempted by the wrong user (such as root operating on a user installation).
    KM_ERROR_NOT_CACHED,                     // Cached data was requested, but it was not available.
    KM_ERROR_PERMISSION_DENIED,              // An operation was not allowed by the administrative policy. For example, an app is not allowed to be installed due to not complying with the parental controls policy.
    KM_ERROR_DECOMPRESSION_FAILED,           // decompression .gz file failed.
    KM_ERROR_CURL_DOWNLOAD_FAILED,           // Download .gz file by curl failed.
    KM_ERROR_CURL_CHECK_URL_FAILED,          // Check url is accessible by curl failed.
    KM_ERROR_SUMMARY_JSON_INVALID,           // summary.json is not a valid json file
    KM_ERROR_LOAD_FILE_FAILED,               // Load file failed.
    KM_ERROR_GET_SUBSUMMARY_GVARIANT_FAILED, // Get subsummary GVariant* failed.
    KM_ERROR_GET_REF_INFO_FAILED,            // Get ref info failed.
    KM_ERROR_NO_COLLECTIONID,                // NO collection_id
    KM_ERROR_NOTHING_TO_DO,                  // Nothing to do.
    KM_ERROR_GET_COMMIT_DATA_FAILED,         // Failed to get commit data from ostree api
    KM_ERROR_DEPLOY_DATA_FAILED,             // Failed to deploy data
    KM_ERROR_FOUND_REMOTE_REF_FAILED,        // Failed to find remote ref
    KM_ERROR_DELETE_EXPORT_FILES_FAILED,     // Failed to delete export files
    KM_ERROR_DELETE_DIRECTORY_FAILED,        // Failed to delete directory
    KM_ERROR_DELETE_DEPLOY_TAG_FAILED,       // Failed to delete deploy tag
    KM_ERROR_DELETE_REF_TAG_FAILED,          // Failed to delete ref tag
    KM_ERROR_PRUNE_REPO_FAILED,              // Failed to prune repo
    KM_ERROR_NOT_NEED_UPDATE,                // Not need to update
    KM_ERROR_LOAD_METADATA_FILE_FAILED,      // Failed to load metadate file
    KM_ERROR_UNINSTALL_FAILED,               // Failed to uninstall app
    KM_ERROR_INSTALL_FAILED,                 // Not all the package is online package or offline package
    KM_ERROR_NO_LAYERS_FOUND,                // No layers found
    KM_ERROR_FORCE_INSTALL,                  // Force install
    KM_ERROR_NO_MD5_FILES,                   // No md5 files
    KM_ERROR_SIGN_FAILED,                    // Sign failed
    KM_ERROR_NOT_SUPPORT_ARCH,               // Not support arch
    KM_ERROR_DEPLOY_CONFICTS,                // Deploy conficts
    KM_ERROR_CONFIG_NOT_FOUND,               // No config file
    KM_ERROR_CONFIG_WRITE_FAILED,            // wrte config failed
    KM_ERROR_INVALID_PARAM,                  // Invalid param
    KM_ERROR_SETLABEL_FAILED,                // Failed to set label
    KM_ERROR_GET_SAFE_MODE_FAILED,           // Get safe mode failed
    KM_ERROR_USER_ABORTED,                   // User aborted installation
    KM_ERROR_CREATE_FILE_FAILED,             // Failed to create file
    KM_ERROR_MD5_CHECK_FAILED,               // MD5 check failed
    KM_ERROR_REPAIR_FAILED                   //Can not repair
} KMErrorCodeEnum;

#endif // KMERROR_H