/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#include "KMCurl.h"

#include "common/KMLogger.h"

KMCurl::KMCurl()
{

}

KMCurl::~KMCurl()
{

}

bool KMCurl::curlApiDownload(string url, string outputFile)
{
    // 初始化 libcurl
    CURL *curl = curl_easy_init();
    if (!curl)
    {
        kmlogger.error("Failed to initialize libcurl.");
        return false;
    }

    // 打开文件用于保存下载的数据
    FILE *file = fopen(outputFile.c_str(), "wb");
    if (!file)
    {
        kmlogger.error("Failed to open %s file for writing!", outputFile.c_str());
        curl_easy_cleanup(curl);
        return false;
    }

    // 设置 libcurl 参数
    curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, file);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, NULL);
    curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 10L); // 设置超时时间为10秒

    // 执行请求
    CURLcode res = curl_easy_perform(curl);

    // 关闭文件
    fclose(file);

    // 校验下载结果
    if (res != CURLE_OK)
    {
        // 检查是否因为超时而中断
        if (res == CURLE_OPERATION_TIMEDOUT)
        {
            kmlogger.error("Failed to download file, Operation timed out.");
        }
        else
        {
            kmlogger.error("Failed to download file");
        }
        return false;
    }

    // 清理 libcurl
    curl_easy_cleanup(curl);

    return true;
}

bool KMCurl::checkURL(const std::string &url, int timeout)
{
    CURL* curl;
    CURLcode res;
    curl = curl_easy_init();

    if (curl)
    {
        curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
        // 设置超时时间为2秒
        curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, timeout);
        // 设置请求不输出
        curl_easy_setopt(curl, CURLOPT_NOBODY, 1L);
        // 执行请求
        res = curl_easy_perform(curl);

        // 清理 curl 资源
        curl_easy_cleanup(curl);

        // 判断请求是否成功
        if (res == CURLE_OK)
        {
            return true;
        }
        else
        {
            std::cerr << "Check http url error: " << curl_easy_strerror(res) << std::endl;
        }
    }
    return false;
}
