#include "KMCheckOverlayIndex.h"

#include <fstream>
#include <filesystem>
#include <sys/utsname.h>

#include "common/KMLogger.h"

namespace fs = std::filesystem;

void KMCheckOverlayIndex::checkOverlayConfig()
{
    std::string outputFilePath = "/opt/kaiming-tools/config";
    std::string outputFile = outputFilePath + "/overlay_index.config";

    std::error_code ec;
    // 如果文件存在且大小 > 0，直接返回
    if (fs::exists(outputFile))
    {
        auto fileSize = fs::file_size(outputFile, ec);
        if (!ec && fileSize > 0)
        {
            KMInfo("Overlay index config already exists and is valid");
            return;
        }
    }

    // 获取 uname 信息
    struct utsname uts;
    if (uname(&uts) != 0)
    {
        KMError("Failed to run uname");
        return;
    }
    std::string unameInfo = uts.release;
    std::string configFile = "/boot/config-" + unameInfo;

    // 检查 config 文件是否存在
    if (!fs::exists(configFile))
    {
        KMError("Config file not found");
        return;
    }

    // 读取 config 文件，查找关键字
    bool found = false;
    {
        std::ifstream ifs(configFile);
        if (!ifs)
        {
            KMError("Failed to open config file");
            return;
        }

        std::string line;
        while (std::getline(ifs, line))
        {
            if (line == "CONFIG_OVERLAY_FS_INDEX=y")
            {
                found = true;
                break;
            }
        }
    }

    // 写入 output 文件
    {
        // 确保目录存在
        if (!fs::exists(outputFilePath))
        {
            if (!fs::create_directories(outputFilePath, ec))
            {
                KMError("Failed to create config directory");
                return;
            }
        }
        std::ofstream ofs(outputFile);
        if (!ofs)
        {
            KMError("Failed to write to file");
            return;
        }
        ofs << (found ? "CONFIG_OVERLAY_FS_INDEX=true" : "CONFIG_OVERLAY_FS_INDEX=false") << std::endl;
        KMInfo("Write overlay index config to " + outputFile);
    }
}
