/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 *
 * See the LICENSE file for more details.
 */

#ifndef __KMRUNNER_ONCEMORE_H__
#define __KMRUNNER_ONCEMORE_H__

#include <vector>
#include <string>

/**
 * @brief 开明多次运行类
 */
class KMRunnerOnce final
{
public:
    KMRunnerOnce() = default;
    ~KMRunnerOnce() = default;

    /**
    * @brief 应用是否已运行
    * @return true 成功 false 失败
    */
    static bool isAlreadyRun(const std::string &appId, std::string &containerid);

    /**
     * @brief 再次运行
     * @param containerid 容器id
     * @param commandArgs 运行命令及参数
     * @return true 成功 false 失败
     */
    static bool runOnce(const std::string &containerid, const std::string &commandArgs);
};

#endif