/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __KMPS_H__
#define __KMPS_H__

#include <optional>

#include "common/KMSubCommand.h"
#include "common/KMBuildinOptions.h"

typedef struct _KMPSInfoList
{
    int64_t pid = 0;
    std::string appid;
    std::string containerid;
    std::string path;
} KMPSInfoList;

/**
 * @brief ``kaiming ps`` 命令可以查看运行中的应用。
 */
class KMPS : public KMSubCommand
{
    DECLARE_DYNCREATE(KMPS);

public:
    KMPS();
    ~KMPS() override;

    int dispose(int argc, char **argv) override;
    void init();

private:
    void printAppInfo(const std::vector<KMPSInfoList> &psInfos) const;

private:
    class Options;
    class Private;
    std::shared_ptr<Private> m_dPtr;
};

#endif // __KMPS_H__
