/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __KMEnter_H__
#define __KMEnter_H__

#include <optional>
#include "common/KMSubCommand.h"
#include "common/KMBuildinOptions.h"

typedef struct _KMEnterInfoList
{
    int64_t pid = 0;
    std::string appid;
    std::string containerid;
    std::string path;
} KMEnterInfoList;

/**
* @brief ``kaiming Enter`` 命令可以查看运行中的应用。
*/
class KMEnter : public KMSubCommand
{
    DECLARE_DYNCREATE(KMEnter);

public:
    KMEnter();
    ~KMEnter() override;

    /**
    * @brief enter 
    * 在正在运行的容器中运行命令
    * @param argc 参数个数
    * @param argv 参数列表
    * @return int 0:成功,非0:失败
    */
    int dispose(int argc, char **argv) final;

    /**
    * @brief 开始运行
    * @return true 成功 false 失败
    */
    bool start();

    /**
    * @brief 初始化
    */
    void init();

protected:
    /**
    * @brief 组装command运行命令
    */
    std::vector<std::string> assembleCommand() const;

    /**
     * @brief 获取信息
    */
    std::vector<KMEnterInfoList> getInfos() const;

private:
    /**
     * @brief 解析命令行参数
     * @param argc 参数个数
     * @param argv 参数列表
     * @return true 成功 false 失败
     */
    bool parseArgs(int argc, char **argv);

private:
    class Options;
    class Private;
    std::shared_ptr<Private> m_dPtr;
};

#endif // __KMEnter_H__
