/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __KMDBUSCLIENT_H__
#define __KMDBUSCLIENT_H__

#include <gio/gio.h>
#include <string>
#include <iostream>
#include <atomic>
#include <thread>

class KMDbusClient
{
public:
    KMDbusClient();
    ~KMDbusClient();

    //调用安装方法
    bool install(const std::string& name, const std::string& branch);

    //运行事件循环，监听进度信号
    void run();

    //停止事件循环
    void stop();
    
private:
    GDBusConnection* connection = nullptr;
    GDBusProxy* proxy = nullptr;

    // 处理progresschangessignal 信号的回调函数
    static void on_progress_change(GDBusProxy *proxy, const gchar *sender_name,
                                   const gchar *signal_name, GVariant *parameters, 
                                   gpointer user_data);
    
    GMainLoop* loop;
    std::atomic<bool> running;
};


#endif // !__KMDBUSCLIENT_H__