/*
 * Copyright (c) KylinSoft  Co., Ltd. 2024. All rights reserved.
 *
 * kaiming is licensed under the GPL v2.0+.
 * 
 * See the LICENSE file for more details.
 */

#ifndef __KMBUILDINIT_H__
#define __KMBUILDINIT_H__

#include <optional>
#include <filesystem>

#include "common/KMSubCommand.h"
#include "common/KMBuildinsUtils.h"
#include "common/KMCommonTypePrivate.h"
#include "KMDbusClient.h"
#include "common/KMJsonHelper.h"

namespace fs = std::filesystem;

/**
 * @brief 	 构建目录树初始化
 * @note	 供kaiming-builder构建流程中调用
 */
class KMBuildInit : public KMSubCommand
{
    DECLARE_DYNCREATE(KMBuildInit);

public:
    KMBuildInit();
    ~KMBuildInit() override;

    int dispose(int argc, char **argv) override;

    /**
     * @brief : 检查app与runtime或depend的base或runtime
     * @param : runtime或depend的路径
     * @param : true: 检查app与depend的runtime；false:检查app与runtime的base
     */
    bool checkBaseOrRuntime(const fs::path &infoPath , const bool runtimeFlag = false) const;

    /**
     * @brief : 获取depend路径
     * @param : depend名称
     * @return : depend所在路径
     */
    std::string getDependPath(const std::string &depend);

    /**
     * @brief: 处理depend依赖
     */
    void addDependsForApp(const std::vector<std::string> &depends, std::vector<std::string>&all_depends);
    void addDependsForDepend(const std::vector<std::string> &depends);

private:
    void init(int argc, char **argv);

    int run();

    // static bool isV10Sp1();
    // void disableKysec();
    // void enableKysec();
    // bool hasKysecAttr(const std::string& path, const std::string& attrName);
    // void unsetFilesSecurityAttr(const std::string& path, const std::string& attrName);
    // void unsetDirsSecurityAttr(const std::string& path, const std::string& attrName);

    void generateMetadata();
    bool installDev(KMDbusClient& client, const std::string& name, const std::string& channel);

    /**
     * @brief : 解析base/runtime等的pref
     * @param : [in] pref, 格式如：top.openkylin.base/stable/2.0.0
     * @return: std::optional<KMRef>
     */ 
    static std::optional<KMRef> parsePref(const std::string& pref);

private:
    class Options;
    class Private;
    std::unique_ptr<Private> d;
};

#endif // !__KMBUILDINIT_H__
