/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextFuncBuiltins {

    static abstract class GraalPyPrivate_CFunction_SetDoc
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_CFunction_SetDoc() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object setString(Object functionObj, TruffleString doc) {
            return GraalPyPrivate_CFunction_SetDoc.setDoc(functionObj, doc);
        }

        @Specialization(guards={"isNoValue(nullValue)"})
        @CompilerDirectives.TruffleBoundary
        static Object setNull(Object functionObj, PNone nullValue) {
            return GraalPyPrivate_CFunction_SetDoc.setDoc(functionObj, null);
        }

        private static PNone setDoc(Object functionObj, TruffleString doc) {
            PBuiltinFunction function;
            if (functionObj instanceof PBuiltinFunction) {
                PBuiltinFunction builtinFunction;
                function = builtinFunction = (PBuiltinFunction)functionObj;
            } else if (functionObj instanceof PBuiltinMethod) {
                PBuiltinMethod builtinMethod = (PBuiltinMethod)functionObj;
                function = builtinMethod.getBuiltinFunction();
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected object passed to GraalPyCFunction_SetDoc");
            }
            function.setAttribute(SpecialAttributeNames.T___DOC__, doc != null ? doc : PNone.NONE);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyClassMethod_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyClassMethod_New() {
        }

        @Specialization
        static Object staticmethod(Object callable, @Bind PythonLanguage language) {
            return PFactory.createClassmethodFromCallableObj(language, callable);
        }
    }

    static abstract class PyStaticMethod_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyStaticMethod_New() {
        }

        @Specialization
        static Object staticmethod(Object func, @Bind PythonLanguage language) {
            PDecoratedMethod res = PFactory.createStaticmethod(language);
            res.setCallable(func);
            return res;
        }
    }
}

