/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lmediathek/tool/FileDialogs;", "", "<init>", "()V", "Companion", "MediathekView"})
public final class FileDialogs {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final File chooseDirectoryLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseDirectoryLocation(parent, title, initialFile);
    }

    @JvmStatic
    @Nullable
    public static final File chooseLoadFileLocation(@NotNull JDialog parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseLoadFileLocation(parent, title, initialFile);
    }

    @JvmStatic
    @Nullable
    public static final File chooseLoadFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseLoadFileLocation(parent, title, initialFile);
    }

    @JvmStatic
    @Nullable
    public static final File chooseSaveFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseSaveFileLocation(parent, title, initialFile);
    }

    @JvmStatic
    @Nullable
    public static final File chooseSaveFileLocation(@NotNull JDialog parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseSaveFileLocation(parent, title, initialFile);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u000e"}, d2={"Lmediathek/tool/FileDialogs$Companion;", "", "<init>", "()V", "chooseDirectoryLocation", "Ljava/io/File;", "parent", "Ljava/awt/Frame;", "title", "", "initialFile", "chooseLoadFileLocation", "Ljavax/swing/JDialog;", "chooseSaveFileLocation", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final File chooseDirectoryLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)initialFile, (String)"initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog(parent, title);
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                chooser.setMode(0);
                chooser.setMultipleMode(false);
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkNotNull((Object)files);
                    if (!(files.length == 0)) {
                        resultFile = files[0];
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showOpenDialog(parent) == 0) {
                    resultFile = new File(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            return resultFile;
        }

        @JvmStatic
        @Nullable
        public final File chooseLoadFileLocation(@NotNull JDialog parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)initialFile, (String)"initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                FileDialog chooser = new FileDialog(parent, title);
                chooser.setMode(0);
                chooser.setMultipleMode(false);
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkNotNull((Object)files);
                    if (!(files.length == 0)) {
                        resultFile = files[0];
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showOpenDialog(parent) == 0) {
                    resultFile = new File(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            return resultFile;
        }

        @JvmStatic
        @Nullable
        public final File chooseLoadFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)initialFile, (String)"initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                FileDialog chooser = new FileDialog(parent, title);
                chooser.setMode(0);
                chooser.setMultipleMode(false);
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkNotNull((Object)files);
                    if (!(files.length == 0)) {
                        resultFile = files[0];
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showOpenDialog(parent) == 0) {
                    resultFile = new File(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            return resultFile;
        }

        @JvmStatic
        @Nullable
        public final File chooseSaveFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)initialFile, (String)"initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                FileDialog chooser = new FileDialog(parent, title);
                chooser.setMode(1);
                chooser.setMultipleMode(false);
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkNotNull((Object)files);
                    if (!(files.length == 0)) {
                        resultFile = files[0];
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showSaveDialog(parent) == 0) {
                    resultFile = new File(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            return resultFile;
        }

        @JvmStatic
        @Nullable
        public final File chooseSaveFileLocation(@NotNull JDialog parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)initialFile, (String)"initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                FileDialog chooser = new FileDialog(parent, title);
                chooser.setMode(1);
                chooser.setMultipleMode(false);
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkNotNull((Object)files);
                    if (!(files.length == 0)) {
                        resultFile = files[0];
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (((CharSequence)initialFile).length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showSaveDialog(parent) == 0) {
                    resultFile = new File(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            return resultFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

