/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.geonames;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.fibs.geotag.Settings;
import org.fibs.geotag.geonames.GeonamesService;
import org.fibs.geotag.geonames.Location;
import org.fibs.geotag.util.Proxies;
import org.fibs.geotag.util.Units;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class LocationHandler
extends DefaultHandler {
    private List<Location> locations = new ArrayList<Location>();
    private Location currentLocation = null;
    private StringBuilder currentValue = null;

    public LocationHandler(String latitude, String longitude) {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this);
            GeonamesService service = new GeonamesService("findNearby");
            service.addParameter("lat", latitude);
            service.addParameter("lng", longitude);
            service.addParameter("style", "FULL");
            boolean useRadius = Settings.get(Settings.SETTING.GEONAMES_USE_RADIUS, false);
            if (useRadius) {
                Units.DISTANCE unit = Units.DISTANCE.values()[Settings.get(Settings.SETTING.DISTANCE_UNIT, 0)];
                int radius = Settings.get(Settings.SETTING.GEONAMES_RADIUS, 5);
                double radiusKm = Units.convert((double)radius, unit, Units.DISTANCE.KILOMETRES);
                if (radiusKm != 0.0) {
                    service.addParameter("radius", radiusKm);
                }
            }
            int maxRows = Settings.get(Settings.SETTING.GEONAMES_MAX_ROWS, 5);
            service.addParameter("maxRows", maxRows);
            String language = Locale.getDefault().getLanguage();
            if (Settings.get(Settings.SETTING.GEONAMES_OVERRIDE_LANGUAGE, false)) {
                language = Settings.get(Settings.SETTING.GEONAMES_LANGUAGE, "");
            }
            service.addParameter("lang", language);
            String url = service.buildURL();
            System.out.println(url);
            URL request = new URL(url);
            URLConnection connection = request.openConnection(Proxies.getProxy());
            connection.setReadTimeout(30000);
            InputStream inputStream = connection.getInputStream();
            xmlReader.parse(new InputSource(inputStream));
            inputStream.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        this.currentValue = null;
        ELEMENTS[] eLEMENTSArray = ELEMENTS.values();
        int n = eLEMENTSArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELEMENTS tag = eLEMENTSArray[n2];
            if (tag.toString().equals(localName)) {
                this.currentValue = new StringBuilder();
                if (tag != ELEMENTS.geoname) break;
                this.currentLocation = new Location();
                break;
            }
            ++n2;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ELEMENTS[] eLEMENTSArray = ELEMENTS.values();
        int n = eLEMENTSArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELEMENTS tag = eLEMENTSArray[n2];
            if (tag.toString().equals(localName)) {
                switch (tag) {
                    case geonames: {
                        break;
                    }
                    case geoname: {
                        this.locations.add(this.currentLocation);
                        this.currentLocation = null;
                        break;
                    }
                    case name: {
                        this.currentLocation.setName(this.currentValue.toString());
                        break;
                    }
                    case lat: {
                        this.currentLocation.setLatitude(this.currentValue.toString());
                        break;
                    }
                    case lng: {
                        this.currentLocation.setLongitude(this.currentValue.toString());
                        break;
                    }
                    case countryName: {
                        this.currentLocation.setCountryName(this.currentValue.toString());
                        break;
                    }
                    case adminName1: {
                        this.currentLocation.setProvince(this.currentValue.toString());
                        break;
                    }
                    case distance: {
                        this.currentLocation.setDistance(Double.parseDouble(this.currentValue.toString().replace(',', '.')));
                        break;
                    }
                    case alternateNames: {
                        if (this.currentValue.toString().length() <= 0) break;
                        this.currentLocation.setAlternateNames(this.currentValue.toString());
                        break;
                    }
                    case fcodeName: {
                        this.currentLocation.setFeatureName(this.currentValue.toString());
                        break;
                    }
                    case fcl: {
                        this.currentLocation.setFeatureClass(this.currentValue.toString());
                        break;
                    }
                }
            }
            ++n2;
        }
        this.currentValue = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentValue != null) {
            this.currentValue.append(ch, start, length);
        }
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    static enum ELEMENTS {
        geonames,
        geoname,
        name,
        lat,
        lng,
        countryName,
        adminName1,
        distance,
        alternateNames,
        fcodeName,
        fcl;

    }
}

