/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import writer2latex.api.BatchConverter;
import writer2latex.api.BatchHandler;
import writer2latex.api.Converter;
import writer2latex.api.ConverterResult;
import writer2latex.api.IndexPageEntry;
import writer2latex.api.OutputFile;
import writer2latex.util.Misc;

public abstract class BatchConverterBase
implements BatchConverter {
    private Converter converter = null;

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void convert(File source, File target, boolean bRecurse, BatchHandler handler) {
        handler.startConversion();
        this.convertDirectory(source, target, bRecurse, source.getName(), handler);
        handler.endConversion();
    }

    protected abstract String getIndexFileName();

    private boolean convertDirectory(File indir, File outdir, boolean bRecurse, String sHeading, BatchHandler handler) {
        int i;
        String sUplink;
        handler.startDirectory(indir.getPath());
        File[] contents = indir.listFiles();
        int nLen = contents.length;
        IndexPageEntry[] entries = new IndexPageEntry[nLen];
        if (bRecurse) {
            sUplink = this.getConfig().getOption("uplink");
            for (i = 0; i < nLen; ++i) {
                if (!contents[i].isDirectory()) continue;
                this.getConfig().setOption("uplink", "../" + this.getIndexFileName());
                File newOutdir = new File(outdir, contents[i].getName());
                String sNewHeading = sHeading + " - " + contents[i].getName();
                boolean bResult = this.convertDirectory(contents[i], newOutdir, bRecurse, sNewHeading, handler);
                this.getConfig().setOption("uplink", sUplink);
                if (!bResult) {
                    return false;
                }
                IndexPageEntry entry = new IndexPageEntry(Misc.makeHref(contents[i].getName() + "/" + this.getIndexFileName()), true);
                entry.setDisplayName(contents[i].getName());
                entries[i] = entry;
            }
        }
        if (this.converter != null) {
            sUplink = this.getConfig().getOption("uplink");
            for (i = 0; i < nLen; ++i) {
                if (!contents[i].isFile()) continue;
                this.getConfig().setOption("uplink", this.getIndexFileName());
                String sLinkFile = this.convertFile(contents[i], outdir, handler);
                this.getConfig().setOption("uplink", sUplink);
                if (sLinkFile == null) continue;
                IndexPageEntry entry = new IndexPageEntry(Misc.makeHref(sLinkFile), false);
                entry.setDisplayName(Misc.removeExtension(sLinkFile));
                entries[i] = entry;
                if (!handler.cancel()) continue;
                return false;
            }
        }
        OutputFile indexFile = this.createIndexFile(sHeading, entries);
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        boolean bSuccess = true;
        File outfile = new File(outdir, indexFile.getFileName());
        try {
            FileOutputStream fos = new FileOutputStream(outfile);
            indexFile.write(fos);
            fos.flush();
            fos.close();
        }
        catch (Exception writeExcept) {
            bSuccess = false;
        }
        handler.endDirectory(indir.getPath(), bSuccess);
        return !handler.cancel();
    }

    private String convertFile(File infile, File outdir, BatchHandler handler) {
        handler.startFile(infile.getPath());
        if (!(infile.getName().endsWith(".odt") || infile.getName().endsWith(".ods") || infile.getName().endsWith(".odp"))) {
            handler.endFile(infile.getPath(), false);
            return null;
        }
        ConverterResult dataOut = null;
        try {
            dataOut = this.converter.convert(infile, Misc.removeExtension(infile.getName()));
        }
        catch (FileNotFoundException e) {
            handler.endFile(infile.getPath(), false);
            return null;
        }
        catch (IOException e) {
            handler.endFile(infile.getPath(), false);
            return null;
        }
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        try {
            dataOut.write(outdir);
        }
        catch (IOException e) {
            handler.endFile(infile.getPath(), false);
            return null;
        }
        handler.endFile(infile.getPath(), true);
        return dataOut.getMasterDocument().getFileName();
    }
}

