/* Generated by wayland-scanner 1.23.1 */

#ifndef WAYFIRE_SHELL_UNSTABLE_V2_CLIENT_PROTOCOL_H
#define WAYFIRE_SHELL_UNSTABLE_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_wayfire_shell_unstable_v2 The wayfire_shell_unstable_v2 protocol
 * @section page_ifaces_wayfire_shell_unstable_v2 Interfaces
 * - @subpage page_iface_zwf_shell_manager_v2 - DE integration
 * - @subpage page_iface_zwf_output_v2 - A wrapper for wl_output
 * - @subpage page_iface_zwf_hotspot_v2 - An edge of the output defined by 1 or 2 edges
 * - @subpage page_iface_zwf_surface_v2 - A special surface
 */
struct wl_output;
struct wl_surface;
struct zwf_hotspot_v2;
struct zwf_output_v2;
struct zwf_shell_manager_v2;
struct zwf_surface_v2;

#ifndef ZWF_SHELL_MANAGER_V2_INTERFACE
#define ZWF_SHELL_MANAGER_V2_INTERFACE
/**
 * @page page_iface_zwf_shell_manager_v2 zwf_shell_manager_v2
 * @section page_iface_zwf_shell_manager_v2_desc Description
 *
 * This protocol provides additional events and requests for special DE
 * clients like panels, docks, etc.
 *
 * It is meant as an addition for protocols like wlr-layer-shell.
 * @section page_iface_zwf_shell_manager_v2_api API
 * See @ref iface_zwf_shell_manager_v2.
 */
/**
 * @defgroup iface_zwf_shell_manager_v2 The zwf_shell_manager_v2 interface
 *
 * This protocol provides additional events and requests for special DE
 * clients like panels, docks, etc.
 *
 * It is meant as an addition for protocols like wlr-layer-shell.
 */
extern const struct wl_interface zwf_shell_manager_v2_interface;
#endif
#ifndef ZWF_OUTPUT_V2_INTERFACE
#define ZWF_OUTPUT_V2_INTERFACE
/**
 * @page page_iface_zwf_output_v2 zwf_output_v2
 * @section page_iface_zwf_output_v2_desc Description
 *
 * Represents a single output.
 * Each output is managed independently from the others.
 * @section page_iface_zwf_output_v2_api API
 * See @ref iface_zwf_output_v2.
 */
/**
 * @defgroup iface_zwf_output_v2 The zwf_output_v2 interface
 *
 * Represents a single output.
 * Each output is managed independently from the others.
 */
extern const struct wl_interface zwf_output_v2_interface;
#endif
#ifndef ZWF_HOTSPOT_V2_INTERFACE
#define ZWF_HOTSPOT_V2_INTERFACE
/**
 * @page page_iface_zwf_hotspot_v2 zwf_hotspot_v2
 * @section page_iface_zwf_hotspot_v2_desc Description
 * @section page_iface_zwf_hotspot_v2_api API
 * See @ref iface_zwf_hotspot_v2.
 */
/**
 * @defgroup iface_zwf_hotspot_v2 The zwf_hotspot_v2 interface
 */
extern const struct wl_interface zwf_hotspot_v2_interface;
#endif
#ifndef ZWF_SURFACE_V2_INTERFACE
#define ZWF_SURFACE_V2_INTERFACE
/**
 * @page page_iface_zwf_surface_v2 zwf_surface_v2
 * @section page_iface_zwf_surface_v2_desc Description
 * @section page_iface_zwf_surface_v2_api API
 * See @ref iface_zwf_surface_v2.
 */
/**
 * @defgroup iface_zwf_surface_v2 The zwf_surface_v2 interface
 */
extern const struct wl_interface zwf_surface_v2_interface;
#endif

#define ZWF_SHELL_MANAGER_V2_GET_WF_OUTPUT 0
#define ZWF_SHELL_MANAGER_V2_GET_WF_SURFACE 1


/**
 * @ingroup iface_zwf_shell_manager_v2
 */
#define ZWF_SHELL_MANAGER_V2_GET_WF_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_shell_manager_v2
 */
#define ZWF_SHELL_MANAGER_V2_GET_WF_SURFACE_SINCE_VERSION 1

/** @ingroup iface_zwf_shell_manager_v2 */
static inline void
zwf_shell_manager_v2_set_user_data(struct zwf_shell_manager_v2 *zwf_shell_manager_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwf_shell_manager_v2, user_data);
}

/** @ingroup iface_zwf_shell_manager_v2 */
static inline void *
zwf_shell_manager_v2_get_user_data(struct zwf_shell_manager_v2 *zwf_shell_manager_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwf_shell_manager_v2);
}

static inline uint32_t
zwf_shell_manager_v2_get_version(struct zwf_shell_manager_v2 *zwf_shell_manager_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwf_shell_manager_v2);
}

/** @ingroup iface_zwf_shell_manager_v2 */
static inline void
zwf_shell_manager_v2_destroy(struct zwf_shell_manager_v2 *zwf_shell_manager_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zwf_shell_manager_v2);
}

/**
 * @ingroup iface_zwf_shell_manager_v2
 */
static inline struct zwf_output_v2 *
zwf_shell_manager_v2_get_wf_output(struct zwf_shell_manager_v2 *zwf_shell_manager_v2, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwf_shell_manager_v2,
			 ZWF_SHELL_MANAGER_V2_GET_WF_OUTPUT, &zwf_output_v2_interface, wl_proxy_get_version((struct wl_proxy *) zwf_shell_manager_v2), 0, output, NULL);

	return (struct zwf_output_v2 *) id;
}

/**
 * @ingroup iface_zwf_shell_manager_v2
 */
static inline struct zwf_surface_v2 *
zwf_shell_manager_v2_get_wf_surface(struct zwf_shell_manager_v2 *zwf_shell_manager_v2, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwf_shell_manager_v2,
			 ZWF_SHELL_MANAGER_V2_GET_WF_SURFACE, &zwf_surface_v2_interface, wl_proxy_get_version((struct wl_proxy *) zwf_shell_manager_v2), 0, surface, NULL);

	return (struct zwf_surface_v2 *) id;
}

#ifndef ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM
#define ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM
enum zwf_output_v2_hotspot_edge {
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_TOP = 1,
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_BOTTOM = 2,
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_LEFT = 4,
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_RIGHT = 8,
};
#endif /* ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM */

/**
 * @ingroup iface_zwf_output_v2
 * @struct zwf_output_v2_listener
 */
struct zwf_output_v2_listener {
	/**
	 * A window was fullscreened
	 *
	 * Emitted when a window gets fullscreened on the given output.
	 * In this mode, windows in the TOP layer are not visible.
	 *
	 * There will be no two consecutive enter_fullscreen calls, i.e. if
	 * fullscreen mode is entered it will be exited before going into
	 * this mode again.
	 */
	void (*enter_fullscreen)(void *data,
				 struct zwf_output_v2 *zwf_output_v2);
	/**
	 * A window was fullscreened
	 *
	 * Emitted when the output is no longer in fullscreen mode. Each
	 * leave_fullscreen has a corresponding enter_fullscreen before it.
	 */
	void (*leave_fullscreen)(void *data,
				 struct zwf_output_v2 *zwf_output_v2);
};

/**
 * @ingroup iface_zwf_output_v2
 */
static inline int
zwf_output_v2_add_listener(struct zwf_output_v2 *zwf_output_v2,
			   const struct zwf_output_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwf_output_v2,
				     (void (**)(void)) listener, data);
}

#define ZWF_OUTPUT_V2_INHIBIT_OUTPUT 0
#define ZWF_OUTPUT_V2_INHIBIT_OUTPUT_DONE 1
#define ZWF_OUTPUT_V2_CREATE_HOTSPOT 2

/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_ENTER_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_LEAVE_FULLSCREEN_SINCE_VERSION 1

/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_INHIBIT_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_INHIBIT_OUTPUT_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_CREATE_HOTSPOT_SINCE_VERSION 1

/** @ingroup iface_zwf_output_v2 */
static inline void
zwf_output_v2_set_user_data(struct zwf_output_v2 *zwf_output_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwf_output_v2, user_data);
}

/** @ingroup iface_zwf_output_v2 */
static inline void *
zwf_output_v2_get_user_data(struct zwf_output_v2 *zwf_output_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwf_output_v2);
}

static inline uint32_t
zwf_output_v2_get_version(struct zwf_output_v2 *zwf_output_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwf_output_v2);
}

/** @ingroup iface_zwf_output_v2 */
static inline void
zwf_output_v2_destroy(struct zwf_output_v2 *zwf_output_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zwf_output_v2);
}

/**
 * @ingroup iface_zwf_output_v2
 *
 * Request the compositor to not render the output, so the output usually
 * is cleared to black color.  To enable output rendering again, call
 * inhibit_output_done.
 */
static inline void
zwf_output_v2_inhibit_output(struct zwf_output_v2 *zwf_output_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwf_output_v2,
			 ZWF_OUTPUT_V2_INHIBIT_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) zwf_output_v2), 0);
}

/**
 * @ingroup iface_zwf_output_v2
 *
 * Stop inhibiting the output. This must be called as many times as
 * inhibit_output was called to actually uninhibit rendering.
 *
 * The inhibit/inhibit_done requests can be called multiple times, even
 * from different apps, so don't assume that a call to inhibit_done would
 * always mean actually starting the rendering process.
 */
static inline void
zwf_output_v2_inhibit_output_done(struct zwf_output_v2 *zwf_output_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwf_output_v2,
			 ZWF_OUTPUT_V2_INHIBIT_OUTPUT_DONE, NULL, wl_proxy_get_version((struct wl_proxy *) zwf_output_v2), 0);
}

/**
 * @ingroup iface_zwf_output_v2
 *
 * A hotspot on the output is an edge or a corner region of the
 * output where the mouse or touch point has been residing for a given
 * amount of time.
 *
 * The hotspot can be used for example for autohiding panels, where the
 * panel is shown when the input hovers on the edge of the output for a
 * specific amount of time.
 */
static inline struct zwf_hotspot_v2 *
zwf_output_v2_create_hotspot(struct zwf_output_v2 *zwf_output_v2, uint32_t hotspot, uint32_t threshold, uint32_t timeout)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwf_output_v2,
			 ZWF_OUTPUT_V2_CREATE_HOTSPOT, &zwf_hotspot_v2_interface, wl_proxy_get_version((struct wl_proxy *) zwf_output_v2), 0, hotspot, threshold, timeout, NULL);

	return (struct zwf_hotspot_v2 *) id;
}

/**
 * @ingroup iface_zwf_hotspot_v2
 * @struct zwf_hotspot_v2_listener
 */
struct zwf_hotspot_v2_listener {
	/**
	 * Hotspot was triggered
	 *
	 * Means that the mouse and/or touch finger was inside the
	 * indicated hotspot for the given amount of time.
	 *
	 * Emitted at most once for each entry of the input inside the
	 * hotspot.
	 */
	void (*enter)(void *data,
		      struct zwf_hotspot_v2 *zwf_hotspot_v2);
	/**
	 * Input left hotspot
	 *
	 * This event indicates that the mouse or touch point has left
	 * the hotspot area.
	 *
	 * Emitted only once after each enter.
	 */
	void (*leave)(void *data,
		      struct zwf_hotspot_v2 *zwf_hotspot_v2);
};

/**
 * @ingroup iface_zwf_hotspot_v2
 */
static inline int
zwf_hotspot_v2_add_listener(struct zwf_hotspot_v2 *zwf_hotspot_v2,
			    const struct zwf_hotspot_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwf_hotspot_v2,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_zwf_hotspot_v2
 */
#define ZWF_HOTSPOT_V2_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_hotspot_v2
 */
#define ZWF_HOTSPOT_V2_LEAVE_SINCE_VERSION 1


/** @ingroup iface_zwf_hotspot_v2 */
static inline void
zwf_hotspot_v2_set_user_data(struct zwf_hotspot_v2 *zwf_hotspot_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwf_hotspot_v2, user_data);
}

/** @ingroup iface_zwf_hotspot_v2 */
static inline void *
zwf_hotspot_v2_get_user_data(struct zwf_hotspot_v2 *zwf_hotspot_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwf_hotspot_v2);
}

static inline uint32_t
zwf_hotspot_v2_get_version(struct zwf_hotspot_v2 *zwf_hotspot_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwf_hotspot_v2);
}

/** @ingroup iface_zwf_hotspot_v2 */
static inline void
zwf_hotspot_v2_destroy(struct zwf_hotspot_v2 *zwf_hotspot_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zwf_hotspot_v2);
}

#define ZWF_SURFACE_V2_INTERACTIVE_MOVE 0


/**
 * @ingroup iface_zwf_surface_v2
 */
#define ZWF_SURFACE_V2_INTERACTIVE_MOVE_SINCE_VERSION 1

/** @ingroup iface_zwf_surface_v2 */
static inline void
zwf_surface_v2_set_user_data(struct zwf_surface_v2 *zwf_surface_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwf_surface_v2, user_data);
}

/** @ingroup iface_zwf_surface_v2 */
static inline void *
zwf_surface_v2_get_user_data(struct zwf_surface_v2 *zwf_surface_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwf_surface_v2);
}

static inline uint32_t
zwf_surface_v2_get_version(struct zwf_surface_v2 *zwf_surface_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwf_surface_v2);
}

/** @ingroup iface_zwf_surface_v2 */
static inline void
zwf_surface_v2_destroy(struct zwf_surface_v2 *zwf_surface_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zwf_surface_v2);
}

/**
 * @ingroup iface_zwf_surface_v2
 */
static inline void
zwf_surface_v2_interactive_move(struct zwf_surface_v2 *zwf_surface_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwf_surface_v2,
			 ZWF_SURFACE_V2_INTERACTIVE_MOVE, NULL, wl_proxy_get_version((struct wl_proxy *) zwf_surface_v2), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
