from typing import List, Optional, Union

SWITCH_MATRIX_PI500: List[List[int]] = [
    # Row 0 (0)
    [3, 1], [6, 2], [6, 3], [1, 3], [3, 3], [7, 0], [3, 6], [1, 7],
    [6, 7], [6, 10], [7, 10], [4, 11], [7, 9], [6, 11],
    # Row 1 (14)
    [6, 1], [7, 1], [7, 2], [7, 3], [7, 4], [6, 4], [6, 5], [7, 5],
    [7, 6], [7, 7], [7, 8], [6, 8], [6, 6], [1, 10],
    # Row 2 (28)
    [1, 1], [0, 1], [0, 2], [0, 3], [0, 4], [1, 4], [1, 5], [0, 5],
    [0, 6], [0, 7], [0, 8], [1, 8], [1, 6], [2, 10],
    # Row 3 (42)
    [1, 2], [2, 1], [2, 2], [2, 3], [2, 4], [3, 4], [3, 5], [2, 5],
    [2, 6], [2, 7], [2, 8], [3, 8], [4, 10],
    # Row 4 (55)
    [1, 15], [4, 1], [4, 2], [4, 3], [4, 4], [5, 4], [5, 5], [4, 5],
    [4, 6], [4, 7], [5, 8], [2, 15],
    # Row 5 (67)
    [6, 0], [2, 9], [1, 16], [3, 9], [3, 11], [5, 9], [4, 0],
    # Arrow keys (74)
    [3, 14], [5, 14], [5, 11], [5, 12],
    # ISO extra keys (78)
    [3, 2], [4, 8],
    # JIS extra keys (80)
    [0, 10], [5, 6], [5, 1], [5, 2], [5, 3], [5, 7]
]

SWITCH_MATRIX_CONVERSION_PI500_ISO: List[Optional[List[int]]] = [
    [0, 0], [0, 1], [0, 2], [0, 3], [0, 4], [0, 5], [0, 6], [0, 7],
    [0, 8], [0, 9], [0, 10], [0, 11], [0, 12], [0, 14],

    [1, 0], [1, 1], [1, 2], [1, 3], [1, 4], [1, 5], [1, 6], [1, 7],
    [1, 8], [1, 9], [1, 10], [1, 11], [1, 12], [1, 14],

    [2, 0], [2, 2], [2, 3], [2, 4], [2, 5], [2, 6], [2, 7], [2, 8],
    [2, 9], [2, 10], [2, 11], [2, 12], [2, 13], None,

    [3, 0], [3, 2], [3, 3], [3, 4], [3, 5], [3, 6], [3, 7], [3, 8],
    [3, 9], [3, 10], [3, 11], [3, 12], [2, 14],

    [4, 0], [4, 2], [4, 3], [4, 4], [4, 5], [4, 6], [4, 7], [4, 8],
    [4, 9], [4, 10], [4, 11], [4, 14],

    [5, 0], [5, 1], [5, 2], [5, 3], [5, 6], [5, 9], [5, 10],

    [5, 13], [6, 12], [6, 13], [6, 14],

    [4, 1], [3, 13],

    None, None, None, None, None, None
]

SWITCH_MATRIX_PI500PLUS_ISO: List[List[int]] = [
    # Row 0
    [0, 0], [0, 1], [0, 2], [0, 3], [0, 4], [0, 5], [0, 6], [0, 7],
    [0, 8], [0, 9], [0, 10], [0, 11], [0, 12], [0, 13], [0, 14],
    # Row 1
    [1, 0], [1, 1], [1, 2], [1, 3], [1, 4], [1, 5], [1, 6], [1, 7],
    [1, 8], [1, 9], [1, 10], [1, 11], [1, 12], [1, 14], [1, 15],
    # Row 2
    [2, 0], [2, 2], [2, 3], [2, 4], [2, 5], [2, 6], [2, 7], [2, 8],
    [2, 9], [2, 10], [2, 11], [2, 12], [2, 13], [2, 14], [2, 15],
    # Row 3
    [3, 0], [3, 2], [3, 3], [3, 4], [3, 5], [3, 6], [3, 7], [3, 8],
    [3, 9], [3, 10], [3, 11], [3, 12], [3, 13], [3, 15],
    # Row 4
    [4, 0], [4, 1], [4, 2], [4, 3], [4, 4], [4, 5], [4, 6], [4, 7],
    [4, 8], [4, 9], [4, 10], [4, 11], [4, 13], [4, 14], [4, 15],
    # Row 5
    [5, 0], [5, 1], [5, 2], [5, 6], [5, 10], [5, 11], [5, 12],
    [5, 13], [5, 14], [5, 15]
]

SWITCH_MATRIX_PI500PLUS_ANSI: List[List[int]] = [
    # Row 0
    [0, 0], [0, 1], [0, 2], [0, 3], [0, 4], [0, 5], [0, 6], [0, 7],
    [0, 8], [0, 9], [0, 10], [0, 11], [0, 12], [0, 13], [0, 14],
    # Row 1
    [1, 0], [1, 1], [1, 2], [1, 3], [1, 4], [1, 5], [1, 6], [1, 7],
    [1, 8], [1, 9], [1, 10], [1, 11], [1, 12], [1, 14], [1, 15],
    # Row 2
    [2, 0], [2, 2], [2, 3], [2, 4], [2, 5], [2, 6], [2, 7], [2, 8],
    [2, 9], [2, 10], [2, 11], [2, 12], [2, 13], [2, 14], [2, 15],
    # Row 3
    [3, 0], [3, 2], [3, 3], [3, 4], [3, 5], [3, 6], [3, 7], [3, 8],
    [3, 9], [3, 10], [3, 11], [3, 12], [3, 13], [3, 15],
    # Row 4
    [4, 0], [4, 2], [4, 3], [4, 4], [4, 5], [4, 6], [4, 7], [4, 8],
    [4, 9], [4, 10], [4, 11], [4, 13], [4, 14], [4, 15],
    # Row 5
    [5, 0], [5, 1], [5, 2], [5, 6], [5, 10], [5, 11], [5, 12], [5, 13],
    [5, 14], [5, 15]
]

SWITCH_MATRIX_PI500PLUS_JIS: List[List[int]] = [
    # Row 0
    [0, 0], [0, 1], [0, 2], [0, 3], [0, 4], [0, 5], [0, 6], [0, 7],
    [0, 8], [0, 9], [0, 10], [0, 11], [0, 12], [0, 13], [0, 14],
    # Row 1
    [1, 0], [1, 1], [1, 2], [1, 3], [1, 4], [1, 5], [1, 6], [1, 7],
    [1, 8], [1, 9], [1, 10], [1, 11], [1, 12], [1, 13], [1, 14], [1, 15],
    # Row 2
    [2, 0], [2, 2], [2, 3], [2, 4], [2, 5], [2, 6], [2, 7], [2, 8],
    [2, 9], [2, 10], [2, 11], [2, 12], [2, 13], [2, 14], [2, 15],
    # Row 3
    [3, 0], [3, 2], [3, 3], [3, 4], [3, 5], [3, 6], [3, 7], [3, 8],
    [3, 9], [3, 10], [3, 11], [3, 12], [3, 13], [3, 15],
    # Row 4
    [4, 0], [4, 2], [4, 3], [4, 4], [4, 5], [4, 6], [4, 7], [4, 8],
    [4, 9], [4, 10], [4, 11], [4, 12], [4, 13], [4, 14], [4, 15],
    # Row 5
    [5, 0], [5, 1], [5, 2], [5, 3], [5, 6], [5, 9], [5, 10], [5, 11],
    [5, 12], [5, 13], [5, 14], [5, 15]
]

def convert_switch_matrix(
    smatrix_value: List[int], 
    smatrix: List[List[int]], 
    tmatrix: List[Optional[List[int]]]
) -> Optional[List[int]]:
    """Convert a switch matrix position to another switch matrix position.

    Args:
        smatrix_value: The value of the source switch matrix to convert from.
        smatrix: The source switch matrix.
        tmatrix: The target switch matrix.

    Returns:
        The corresponding position in the target matrix.
    """
    return [tmatrix[i] for i in range(len(smatrix)) if smatrix[i] == smatrix_value][0]