/*
 * Copyright (C) 2024, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: youdiansaodongxi <guojiaqi@kylinos.cn>
 *
 */

#include "ukui-calendar-plugin.h"
#include "calendar-model.h"

#include <QQmlEngine>
#include <QQmlContext>

void UkuiCalendarPlugin::registerTypes(const char *uri)
{
    Q_ASSERT(QString(uri) == QLatin1String("org.ukui.calendar"));
    qmlRegisterModule(uri, 1, 0);
    qmlRegisterSingletonType<CalendarModel>(uri, 1, 0, "CalendarModel", [] (QQmlEngine *, QJSEngine *) -> QObject* {
        return CalendarModel::instance();
    });
}
