/*
 * Copyright (C) 2022, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "icon-provider.h"
#include "icon-helper.h"

namespace UkuiQuick {

static QSize defaultSize = QSize(128, 128);

IconProvider::IconProvider() : QQuickImageProvider(QQmlImageProviderBase::Pixmap)
{

}

QPixmap IconProvider::requestPixmap(const QString &id, QSize *size, const QSize &requestedSize)
{
    QIcon icon = IconHelper::loadIcon(id);
    QPixmap pixmap = icon.pixmap(requestedSize.isEmpty() ? defaultSize : requestedSize);

    if (size) {
        QSize pixmapSize = pixmap.size();
        size->setWidth(pixmapSize.width());
        size->setHeight(pixmapSize.height());
    }

    return pixmap;
}

} // UkuiQuick
