# Contributing

Contributions are welcome! Here's how you can help:

- [Translating](#translations)
- [Contributing code](#code)
- [Reporting issues](#issues)
- [Donating](#donations)

## Translations

Check this nice official documentation from Qt docs as it explains how to translate for a project written with Qt: https://doc.qt.io/qt-5/linguist-translators.html

#### Status:

| Language              | Code  | Status      | Contributors |
| --------------------- | ----- | ----------- | ------------ |
| Spanish | es |  :bookmark:v0.1.0    | [lupoDharkael](https://github.com/lupoDharkael) |
| Catalan | ca |  :bookmark:v0.5.0    | [joamuran](https://github.com/joamuran) |
| Russian | ru |  :bookmark:v0.5.1   | [Shatur95](https://github.com/Shatur95) |
| Chinese (Simplified)  | zh_CN | :bookmark:v0.5.1 | [copie](https://github.com/copie), [hosiet](https://github.com/hosiet) |
| Chinese (Traditional) | zh_TW | :bookmark:v0.5.1 | [PeterDaveHello](https://github.com/PeterDaveHello) |
| Turkish               | tr | :bookmark:v0.5.1 | [oltulu](https://github.com/oltulu) |
| Georgian              | ge | :bookmark:v0.5.1 | [giogziro95](https://github.com/giogziro95) |
| French                | fr | :bookmark:v0.5.1 | [ld892012](https://github.com/ld892012) |
| Polish                | pl | :bookmark:v0.5.1 | [napcok](https://github.com/napcok) |
| Serbian               | sr | :bookmark:v0.6.0 | [cobisimo](https://github.com/cobisimo) |
| Ukrainian             | uk | :bookmark:v0.6.0 | [vboden](https://github.com/vboden) |
| German                | de | :bookmark:v0.6.0 | [DaVukovic](https://github.com/DaVukovic) |

## Code

1. [Fork](https://help.github.com/articles/fork-a-repo/) the repository and [clone](https://help.github.com/articles/cloning-a-repository/) your fork.

2. Start coding!
    - Implement your feature.
    - Check your code works as expected.

3. Commit your changes to a new branch (not `master`, one change per branch) and push it:
    - Commit messages should:
        - Header line: explain the commit in one line (use the imperative)
        - Be descriptive.
        - Have a first line with less than *80 characters* and have a second line that is *empty* if you want to add a description.

4. Once you are happy with your changes, submit a pull request.
     - Open the pull-request.
     - Add a short description explaining briefly what you've done (or if it's a work-in-progress - what you need to do)

## Issues

1. Do a quick search on GitHub to check if the issue has already been reported.
2. [Open an issue](https://github.com/UbuntuKylin/kylin-screenshot/issues/new) and describe the issue you are having - you could include:
     - Screenshots
     - Ways to reproduce the issue.
     - Your kylin-screenshot version.
     - Your platform (e.g. Windows 10 or Ubuntu 15.04 x64)

After reporting you should aim to answer questions or clarifications as this helps pinpoint the cause of the issue.

### Donations

I improve kylin-screenshot in my free time because I want to create something good for everyone to use.
