/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import com.fasterxml.jackson.core.JsonParser;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;

public class MessageBodyReaders {

    public static abstract class CachingDelegatingMessageBodyReader
    implements MessageBodyReader<Object> {
        public static final String DESERIALIZED_REQUEST_BODY_KEY = "request-body";
        @Context
        ServiceLocator serviceLocator;
        private final MessageBodyReader<Object> delegate = this.getDelegate();

        public abstract MessageBodyReader<Object> getDelegate();

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.delegate.isReadable(type, genericType, annotations, mediaType);
        }

        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            ContainerRequestContext requestContext = this.getRequestContext();
            Object object = this.delegate.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            if (requestContext != null) {
                requestContext.setProperty(DESERIALIZED_REQUEST_BODY_KEY, object);
            }
            return object;
        }

        private ContainerRequestContext getRequestContext() {
            return (ContainerRequestContext)this.serviceLocator.getService(ContainerRequestContext.class, new Annotation[0]);
        }
    }

    @Provider
    @Consumes(value={"application/json"})
    public static class CachingJsonMessageBodyReader
    extends CachingDelegatingMessageBodyReader
    implements MessageBodyReader<Object> {
        @Override
        public MessageBodyReader<Object> getDelegate() {
            return new JacksonJsonProvider().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        }
    }
}

