# - Config file for rocprofiler-sdk and its component libraries
# It defines the following variables:
#
# rocprofiler-sdk_VERSION
# rocprofiler-sdk_INCLUDE_DIR
# rocprofiler-sdk_LIB_DIR
# rocprofiler-sdk_LIBRARIES
#
# It provides the following interface libraries:
#
# rocprofiler-sdk::rocprofiler-sdk
# rocprofiler-sdk::rocprofiler-sdk
#

# prevent "target already exists" error
include_guard(DIRECTORY)

# compute paths
get_filename_component(rocprofiler-sdk_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocprofiler-sdk_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocprofiler-sdk_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
get_filename_component(rocprofiler-sdk_ROOT_DIR ${rocprofiler-sdk_INCLUDE_DIR} PATH)

# extra validation
foreach(_rocprofiler-sdk_SUBDIR include/rocprofiler-sdk;lib/rocprofiler-sdk)
    set_and_check(_rocprofiler-sdk_SUBDIR_CHECK
                  "${PACKAGE_PREFIX_DIR}/${_rocprofiler-sdk_SUBDIR}")
    unset(_rocprofiler-sdk_SUBDIR_CHECK)
endforeach()

set(rocprofiler-sdk_LIBRARIES)

# add interface library
add_library(rocprofiler-sdk::rocprofiler-sdk INTERFACE IMPORTED)

target_include_directories(rocprofiler-sdk::rocprofiler-sdk
                           INTERFACE "${rocprofiler-sdk_INCLUDE_DIR}")
target_link_directories(rocprofiler-sdk::rocprofiler-sdk INTERFACE
                        "${rocprofiler-sdk_LIB_DIR}")

if(rocprofiler-sdk_BUILD_TREE
   AND EXISTS "${CMAKE_CURRENT_LIST_DIR}/rocprofiler-sdk-build-config.cmake")
    include("${CMAKE_CURRENT_LIST_DIR}/rocprofiler-sdk-build-config.cmake")
else()
    find_package(
        AMDDeviceLibs
        REQUIRED
        CONFIG
        HINTS
        /opt/rocm/lib/cmake/AMDDeviceLibs
        /opt/rocm
        PATHS
        /opt/rocm/lib/cmake/AMDDeviceLibs
        /opt/rocm)

    find_package(
        amd_comgr
        3.0.0...3.0.999999999999
        REQUIRED
        CONFIG
        HINTS
        /opt/rocm/lib/cmake/amd_comgr
        /opt/rocm
        PATHS
        /opt/rocm/lib/cmake/amd_comgr
        /opt/rocm)

    find_package(
        hsa-runtime64
        1.18.0...1.18.999999999999
        REQUIRED
        CONFIG
        HINTS
        /opt/rocm/lib/cmake/hsa-runtime64
        /opt/rocm
        PATHS
        /opt/rocm/lib/cmake/hsa-runtime64
        /opt/rocm)

    find_package(
        hip
        7.2.0...7.2.999999999999
        REQUIRED
        CONFIG
        HINTS
        /opt/rocm/lib/cmake/hip
        /opt/rocm
        PATHS
        /opt/rocm/lib/cmake/hip
        /opt/rocm)

    include("${rocprofiler-sdk_CMAKE_DIR}/rocprofiler-sdk-config-nolink-target.cmake")

    add_library(rocprofiler-sdk::rocprofiler-sdk-external-nolink INTERFACE IMPORTED)

    # if rccl not found or <rccl/amd_detail/api_trace.h> not found when rocprofiler-sdk
    # was built, use the packaged rccl.h and api_trace.h
    if(NOT 0 OR NOT OFF)
        target_compile_definitions(rocprofiler-sdk::rocprofiler-sdk-external-nolink
                                   INTERFACE ROCPROFILER_SDK_USE_SYSTEM_RCCL=0)
    endif()

    include("${rocprofiler-sdk_CMAKE_DIR}/rocprofiler-sdk-targets.cmake")

    rocprofiler_config_nolink_target(rocprofiler-sdk::rocprofiler-sdk-external-nolink hip::host)
    rocprofiler_config_nolink_target(rocprofiler-sdk::rocprofiler-sdk-external-nolink hsa-runtime64::hsa-runtime64)
    rocprofiler_config_nolink_target(rocprofiler-sdk::rocprofiler-sdk-external-nolink amd_comgr)

    # Library dependencies
    if(rocprofiler-sdk_FIND_COMPONENTS)
        foreach(COMP ${rocprofiler-sdk_FIND_COMPONENTS})
            set(TARG rocprofiler-sdk::rocprofiler-sdk-${COMP})
            if(TARGET ${TARG})
                set(rocprofiler-sdk_${COMP}_FOUND 1)
                list(APPEND rocprofiler-sdk_LIBRARIES ${TARG})
                target_link_libraries(rocprofiler-sdk::rocprofiler-sdk INTERFACE ${TARG})
            else()
                set(rocprofiler-sdk_${COMP}_FOUND 0)
            endif()
        endforeach()
    else()
        foreach(TARG headers;shared-library)
            set(TARG rocprofiler-sdk::rocprofiler-sdk-${TARG})
            list(APPEND rocprofiler-sdk_LIBRARIES ${TARG})
            target_link_libraries(rocprofiler-sdk::rocprofiler-sdk INTERFACE ${TARG})
        endforeach()
    endif()

    if(EXISTS ${rocprofiler-sdk_CMAKE_DIR}/Modules)
        list(INSERT CMAKE_MODULE_PATH 0 ${rocprofiler-sdk_CMAKE_DIR}/Modules)
        find_package(libdw)
        list(REMOVE_AT CMAKE_MODULE_PATH 0)
    endif()

    if(libdw_FOUND AND TARGET libdw::libdw)
        rocprofiler_config_nolink_target(rocprofiler-sdk::rocprofiler-sdk-external-nolink
                                         libdw::libdw)
    endif()

    target_link_libraries(rocprofiler-sdk::rocprofiler-sdk
                          INTERFACE rocprofiler-sdk::rocprofiler-sdk-external-nolink)
endif()

add_executable(rocprofiler-sdk::rocprofv3 IMPORTED)
set_property(
    TARGET rocprofiler-sdk::rocprofv3
    PROPERTY IMPORTED_LOCATION
             ${rocprofiler-sdk_ROOT_DIR}/bin/rocprofv3)

add_executable(rocprofiler-sdk::rocprofv3-avail IMPORTED)
set_property(
    TARGET rocprofiler-sdk::rocprofv3-avail
    PROPERTY IMPORTED_LOCATION ${rocprofiler-sdk_ROOT_DIR}/bin/rocprofv3-avail)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocprofiler-sdk
    FOUND_VAR rocprofiler-sdk_FOUND
    VERSION_VAR rocprofiler-sdk_VERSION
    REQUIRED_VARS rocprofiler-sdk_ROOT_DIR rocprofiler-sdk_INCLUDE_DIR
                  rocprofiler-sdk_LIB_DIR rocprofiler-sdk_LIBRARIES rocprofiler-sdk_VERSION
    HANDLE_COMPONENTS HANDLE_VERSION_RANGE)

if(EXISTS ${rocprofiler-sdk_CMAKE_DIR}/Modules)
    list(APPEND CMAKE_MODULE_PATH ${rocprofiler-sdk_CMAKE_DIR}/Modules)
    include(rocprofiler-sdk-utilities)
endif()

add_executable(rocprofiler-sdk::convert-counters-collection-format IMPORTED)
set_property(
    TARGET rocprofiler-sdk::convert-counters-collection-format
    PROPERTY
        IMPORTED_LOCATION
        ${rocprofiler-sdk_ROOT_DIR}/share/rocprofiler-sdk/convert-counters-collection-format.py
    )
