page_type: reference
description: TensorFlow Lite Task Library Text APIs.

<link rel="stylesheet" href="/site-assets/css/style.css">

<!-- DO NOT EDIT! Automatically generated file. -->


<div itemscope itemtype="http://developers.google.com/ReferenceObject">
<meta itemprop="name" content="tflite_support.task.text" />
<meta itemprop="path" content="Stable" />
</div>

# Module: tflite_support.task.text

<!-- Insert buttons and diff -->

<table class="tfo-notebook-buttons tfo-api nocontent" align="left">
<td>
  <a target="_blank" href="https://github.com/tensorflow/tflite-support/blob/v0.4.4/tensorflow_lite_support/python/task/text/__init__.py">
    <img src="https://www.tensorflow.org/images/GitHub-Mark-32px.png" />
    View source on GitHub
  </a>
</td>
</table>



TensorFlow Lite Task Library Text APIs.


This module provides interface to run TensorFlow Lite natural language
processing models.

## Classes

[`class BertCluAnnotator`](../../tflite_support/task/text/BertCluAnnotator): Class that performs Bert CLU Annotation on text.

[`class BertCluAnnotatorOptions`](../../tflite_support/task/text/BertCluAnnotatorOptions): Options for the Bert CLU Annotator task.

[`class BertNLClassifier`](../../tflite_support/task/text/BertNLClassifier): Class that performs Bert NL classification on text.

[`class BertNLClassifierOptions`](../../tflite_support/task/text/BertNLClassifierOptions): Options for the Bert NL classifier task.

[`class BertQuestionAnswerer`](../../tflite_support/task/text/BertQuestionAnswerer): Class that performs Bert question answering on text.

[`class BertQuestionAnswererOptions`](../../tflite_support/task/text/BertQuestionAnswererOptions): Options for the Bert question answerer task.

[`class NLClassifier`](../../tflite_support/task/text/NLClassifier): Class that performs NL classification on text.

[`class NLClassifierOptions`](../../tflite_support/task/text/NLClassifierOptions): Options for the NL classifier task.

[`class TextEmbedder`](../../tflite_support/task/text/TextEmbedder): Class that performs dense feature vector extraction on text.

[`class TextEmbedderOptions`](../../tflite_support/task/text/TextEmbedderOptions): Options for the text embedder task.

[`class TextSearcher`](../../tflite_support/task/text/TextSearcher): Class to performs text search.

[`class TextSearcherOptions`](../../tflite_support/task/text/TextSearcherOptions): Options for the text search task.
