page_type: reference
description: The TensorFlow Lite Support Library.

<link rel="stylesheet" href="/site-assets/css/style.css">

<!-- DO NOT EDIT! Automatically generated file. -->


<div itemscope itemtype="http://developers.google.com/ReferenceObject">
<meta itemprop="name" content="tflite_support" />
<meta itemprop="path" content="Stable" />
</div>

# Module: tflite_support

<!-- Insert buttons and diff -->

<table class="tfo-notebook-buttons tfo-api nocontent" align="left">

</table>



The TensorFlow Lite Support Library.


Install the pip package:

```
pip install tflite-support
```

This package provides two major features:

* Metadata writers: add metadata to TensorFlow Lite models.
* Task Library: run TensorFlow Lite models of major machine learning tasks.

To learn more about metadata, flatbuffers and TensorFlow Lite models, check out
the [metadata section](https://www.tensorflow.org/lite/convert/metadata) of the
TensorFlow Lite guide.

To learn more about Task Library, check out the
[documentation](https://www.tensorflow.org/lite/inference_with_metadata/task_library/overview)
on the TensorFlow Lite website.

## Modules

[`metadata`](./tflite_support/metadata) module: TensorFlow Lite metadata tools.

[`metadata_schema_py_generated`](./tflite_support/metadata_schema_py_generated) module

[`metadata_writers`](./tflite_support/metadata_writers) module: TF Lite Metadata Writer API.

[`task`](./tflite_support/task) module: The TensorFlow Lite Task Library.
