# Copyright 2023 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

from typing import ClassVar

class EagerContext:
    def __init__(self, *args, **kwargs) -> None: ...

class Runtime:
    class Dialect:
        __members__: ClassVar[dict] = ...  # read-only
        TF: ClassVar[Runtime.Dialect] = ...
        TFG: ClassVar[Runtime.Dialect] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, arg0: EagerContext) -> None: ...
    def CreateFunctionFromString(self, arg0: str) -> Status: ...
    def GetFunctionProtoString(self, arg0: str) -> bytes: ...
    def TransformFunction(self, name: str, pipeline_name: str, dialect: Runtime.Dialect = ...) -> Status: ...

class Status:
    def __init__(self, *args, **kwargs) -> None: ...

def GlobalEagerContext() -> EagerContext: ...
def GlobalPythonEagerContext() -> EagerContext: ...
