# Copyright 2023 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

from typing import overload

class Attribute:
    def __init__(self, *args, **kwargs) -> None: ...

class Block:
    def __init__(self, *args, **kwargs) -> None: ...
    def addArgument(self, *args, **kwargs): ...
    def end(self) -> Block_Iterator: ...
    def new(self) -> Block: ...

class BlockArgument(Value):
    def __init__(self, *args, **kwargs) -> None: ...

class Block_Iterator:
    def __init__(self, *args, **kwargs) -> None: ...

class Builder:
    def __init__(self, arg0: MLIRContext) -> None: ...
    def getFunctionType(self, arg0: list[Type], arg1: list[Type]) -> FunctionType: ...

class FloatType(Type):
    def __init__(self, *args, **kwargs) -> None: ...
    def getBF16(self) -> FloatType: ...
    def getF16(self) -> FloatType: ...
    def getF32(self) -> FloatType: ...
    def getF64(self) -> FloatType: ...

class FuncOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: str, arg1: FunctionType) -> FuncOp: ...
    def getArguments(self) -> list[BlockArgument]: ...
    def getBody(self) -> Region: ...
    def getName(self) -> str: ...
    def getType(self) -> FunctionType: ...

class FunctionType(Type):
    def __init__(self, *args, **kwargs) -> None: ...
    def getResults(self) -> list[Type]: ...

class IntegerAttr(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, arg0: int) -> IntegerAttr: ...

class IntegerType(Type):
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, arg0: int) -> IntegerType: ...

class Location:
    def __init__(self, *args, **kwargs) -> None: ...

class MLIRContext:
    def __init__(self) -> None: ...

class ModuleOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self) -> ModuleOp: ...
    def dump(self) -> None: ...
    def getAsStr(self) -> str: ...
    def push_back(self, arg0) -> None: ...

class OpBuilder:
    @overload
    def __init__(self, arg0: MLIRContext) -> None: ...
    @overload
    def __init__(self, arg0: Region) -> None: ...
    @overload
    def __init__(self, arg0) -> None: ...
    @overload
    def __init__(self, arg0: Block, arg1: Block_Iterator) -> None: ...
    def create(self, *args, **kwargs): ...
    def getContext(self) -> MLIRContext: ...
    def getUnknownLoc(self) -> Location: ...
    def restoreInsertionPoint(self, arg0) -> None: ...
    def saveInsertionPoint(self, *args, **kwargs): ...
    def setInsertionPoint(self, arg0: Block, arg1: Block_Iterator) -> None: ...

class OpBuilder_InsertionPoint:
    def __init__(self, *args, **kwargs) -> None: ...
    def getBlock(self) -> Block: ...

class OpResult(Value):
    def __init__(self, *args, **kwargs) -> None: ...

class Operation:
    def __init__(self, *args, **kwargs) -> None: ...
    def dump(self) -> None: ...
    def getNumResults(self) -> int: ...
    def getRegion(self, arg0: int) -> Region: ...
    def getResult(self, arg0: int) -> OpResult: ...

class OperationState:
    def __init__(self, arg0: Location, arg1: str) -> None: ...
    def addOperands(self, arg0: list[Value]) -> None: ...
    def addRegion(self) -> Region: ...
    def addTypes(self, arg0: list[Type]) -> None: ...

class RankedTensorType(Type):
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, arg0: Type) -> RankedTensorType: ...

class Region:
    def __init__(self, *args, **kwargs) -> None: ...
    def add_block(self) -> None: ...
    def back(self, *args, **kwargs): ...
    def front(self, *args, **kwargs): ...
    def push_back(self, arg0) -> None: ...
    def size(self) -> int: ...

class ReturnOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: list[Value]) -> Operation: ...

class Tf_AddV2Op:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_AnyOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value, arg3: bool) -> Operation: ...

class Tf_ConstOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1) -> Operation: ...

class Tf_EqualOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_GreaterEqualOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_GreaterOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_LegacyCallOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: list[Type], arg2: list[Value], arg3: str) -> Operation: ...

class Tf_LessEqualOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_LessOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_NegOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value) -> Operation: ...

class Tf_NotEqualOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Tf_SubOp:
    def __init__(self, *args, **kwargs) -> None: ...
    def create(self, arg0: Location, arg1: Value, arg2: Value) -> Operation: ...

class Type:
    def __init__(self, *args, **kwargs) -> None: ...

class UnknownLoc:
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self) -> Location: ...

class UnrankedTensorType(Type):
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self) -> UnrankedTensorType: ...

class Value:
    def __init__(self, *args, **kwargs) -> None: ...
    def getType(self, *args, **kwargs): ...

def preloadTensorFlowDialects(arg0) -> None: ...
def verify(arg0: str) -> bool: ...
