// SPDX-License-Identifier: BSD-3-Clause
// rpi-modcopy - Selectively copy kernel modules and their dependencies

#pragma once

#include <filesystem>
#include <set>
#include <string>
#include <vector>

namespace modcopy {

// NOLINTBEGIN(readability-redundant-member-init) ; explicit initialisation preferred for clarity
struct Options {
    std::filesystem::path source{};
    std::filesystem::path dest{};
    std::string kernel_version{};
    std::filesystem::path module_dir{"/usr/lib/modules"};
    std::vector<std::string> modules{};
    bool verbose{false};
    bool dry_run{false};
    bool keep_going{false};
};

struct Result {
    int exit_code{0};
    int modules_copied{0};
    int modules_skipped{0};
    std::set<std::filesystem::path> files_to_copy{};
};
// NOLINTEND(readability-redundant-member-init)

// Resolve modules and their dependencies, returning paths to copy
Result resolve_modules(const Options& opts);

// Copy resolved files from source to destination
Result copy_modules(const Options& opts, const Result& resolved);

// Run depmod on destination to generate index files
int run_depmod(const Options& opts);

}  // namespace modcopy
