/**
 * Copyright (c) 2019-2025 Hailo Technologies Ltd. All rights reserved.
 * Distributed under the MIT license (https://opensource.org/licenses/MIT)
 **/
/**
 * @file status.h
 * @brief Declares status enum for hailo c platform.
**/

#ifndef __STATUS_H__
#define __STATUS_H__

/**
 *  @brief The enumeration of all status codes.
 */

typedef enum {
    /* global statuses */
    HAILO_COMMON_STATUS__SUCCESS = 0,
    HAILO_COMMON_STATUS__UNINITIALIZED,
    
    /* Control protocol module errors */
    HAILO_STATUS__CONTROL_PROTOCOL__OVERRUN_BEFORE_PARAMETER = 0x1000,
    HAILO_STATUS__CONTROL_PROTOCOL__NULL_ARGUMENT_PASSED,
    HAILO_STATUS__CONTROL_PROTOCOL__OVERRUN_AT_PARAMETER,
    HAILO_STATUS__CONTROL_PROTOCOL__UNEXPECTED_ACK_VALUE,
    HAILO_STATUS__CONTROL_PROTOCOL__INVALID_VERSION,
    HAILO_STATUS__CONTROL_PROTOCOL__PART_OF_THE_MESSAGE_NOT_PARSED,
    HAILO_STATUS__CONTROL_PROTOCOL__INVALID_BUFFER_SIZE,
    HAILO_STATUS__CONTROL_PROTOCOL__INVALID_ARGUMENT,

    HAILO_STATUS__FIRMWARE_HEADER_UTILS__CERT_TOO_LARGE = 0x2000,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_FIRMWARE_HEADER_SIZE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INCORRECT_FIRMWARE_HEADER_MAGIC,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__UNSUPPORTED_FIRMWARE__HEADER_VERSION,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__CODE_SIZE_BELOW_MINIMUM,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__CODE_OVERRUNS_RAM_SIZE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_FIRMWARE_CODE_SIZE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_CERT_HEADER_SIZE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_CERT_KEY_SIZE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_CERT_CONTENT_SIZE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_APP_CPU_FIRMWARE_HEADER,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_APP_CPU_FIRMWARE_CERTIFICATE_HEADER,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_CORE_CPU_FIRMWARE_HEADER,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_CORE_CPU_FIRMWARE_CERTIFICATE_HEADER,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__LEFTOVER_DATA_AFTER_LAST_FIRMWARE_HEADER,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__DETECTED_PROHIBITED_DOWNGRADE_ATTEMPT,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_BINARY_TYPE,
    HAILO_STATUS__FIRMWARE_HEADER_UTILS__INVALID_FIRMWARE_TYPE,

    HAILO_STATUS__D2H_EVENTS__INCORRECT_PARAMETER_COUNT = 0x3000,
    HAILO_STATUS__D2H_EVENTS__INCORRECT_PARAMETER_LENGTH,
    HAILO_STATUS__D2H_EVENTS__INVALID_ARGUMENT,

    HAILO_STATUS__FIRMWARE_STATUS__NULL_ARGUMENT_PASSED = 0x4000,
    HAILO_STATUS__FIRMWARE_STATUS__INVALID_COMPONENT_ID,
    HAILO_STATUS__FIRMWARE_STATUS__INVALID_MODULE_ID,
    HAILO_STATUS__FIRMWARE_STATUS__INVALID_STATUS_VALUE,
} HAILO_COMMON_STATUS_t;

#endif /* __STATUS_H__ */
