use std::env;
use std::path::PathBuf;
use std::process::Command;

fn main() {
    // Link against librpifwcrypto
    println!("cargo:rustc-link-lib=rpifwcrypto");

    // Re-run if the header changes
    println!("cargo:rerun-if-changed=/usr/include/rpifwcrypto.h");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    let bindings_file = out_path.join("rpifwcrypto_bindings.rs");

    // Generate bindings using the bindgen CLI tool
    let status = Command::new("bindgen")
        .args([
            "/usr/include/rpifwcrypto.h",
            "--output",
            bindings_file.to_str().unwrap(),
            "--use-core",
            "--allowlist-function",
            "rpi_fw_crypto_.*",
            "--allowlist-type",
            "RPI_FW_CRYPTO_.*",
            "--allowlist-var",
            "RPI_FW_CRYPTO_.*|ARM_CRYPTO_.*",
            "--",
            "-include",
            "stdint.h",
            "-include",
            "stddef.h",
        ])
        .status()
        .expect("Failed to execute bindgen");

    if !status.success() {
        panic!("bindgen failed with status: {}", status);
    }
}
