use clap::CommandFactory;
use clap_mangen::Man;
use std::env;
use std::fs;
use std::path::PathBuf;

include!("src/cli.rs");

fn main() -> std::io::Result<()> {
    let out_dir = PathBuf::from(env::var("OUT_DIR").unwrap());

    let cmd = Args::command();
    let man = Man::new(cmd);

    let mut buffer: Vec<u8> = Default::default();
    man.render(&mut buffer)?;

    fs::write(out_dir.join("block-device-id.1"), buffer)?;

    println!("cargo:rerun-if-changed=src/cli.rs");

    Ok(())
}
